"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupInventoryItemStoreController = void 0;
const common_1 = require("@nestjs/common");
const setup_inventory_item_store_service_1 = require("./setup-inventory-item_store.service");
const setup_inventory_item_store_entity_1 = require("./entities/setup-inventory-item_store.entity");
const auth_guard_1 = require("../auth/auth.guard");
let SetupInventoryItemStoreController = class SetupInventoryItemStoreController {
    constructor(setupInventoryItemStoreService) {
        this.setupInventoryItemStoreService = setupInventoryItemStoreService;
    }
    create(item_storeEntity) {
        return this.setupInventoryItemStoreService.create(item_storeEntity);
    }
    findAll() {
        return this.setupInventoryItemStoreService.findAll();
    }
    findOne(id) {
        return this.setupInventoryItemStoreService.findOne(id);
    }
    update(id, item_storeEntity) {
        return this.setupInventoryItemStoreService.update(id, item_storeEntity);
    }
    remove(id, Hospital_id) {
        return this.setupInventoryItemStoreService.remove(id, Hospital_id);
    }
    setupInventoryItemStore(search) {
        return this.setupInventoryItemStoreService.setupInventoryItemStore(search);
    }
    async findInventoryItemStoreSearch(search, limit, page) {
        try {
            let final_out = await this.setupInventoryItemStoreService.findInventoryItemStoreSearch(search, limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE
            };
        }
    }
};
exports.SetupInventoryItemStoreController = SetupInventoryItemStoreController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [setup_inventory_item_store_entity_1.SetupInventoryItemStore]),
    __metadata("design:returntype", void 0)
], SetupInventoryItemStoreController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SetupInventoryItemStoreController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SetupInventoryItemStoreController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, setup_inventory_item_store_entity_1.SetupInventoryItemStore]),
    __metadata("design:returntype", void 0)
], SetupInventoryItemStoreController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", void 0)
], SetupInventoryItemStoreController.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/keyword/setupInventoryItemStore/:search'),
    __param(0, (0, common_1.Param)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SetupInventoryItemStoreController.prototype, "setupInventoryItemStore", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)("/v2/Setup_Inventory_Item_Store"),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)("limit")),
    __param(2, (0, common_1.Query)("page")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number]),
    __metadata("design:returntype", Promise)
], SetupInventoryItemStoreController.prototype, "findInventoryItemStoreSearch", null);
exports.SetupInventoryItemStoreController = SetupInventoryItemStoreController = __decorate([
    (0, common_1.Controller)('setup-inventory-item-store'),
    __metadata("design:paramtypes", [setup_inventory_item_store_service_1.SetupInventoryItemStoreService])
], SetupInventoryItemStoreController);
//# sourceMappingURL=setup-inventory-item_store.controller.js.map