"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupInventoryItemCategoryService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupInventoryItemCategoryService = class SetupInventoryItemCategoryService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(item_categoryEntity) {
        try {
            const [existing_item_category] = await this.connection.query(`select id from item_category where item_category = ? LIMIT 1`, [item_categoryEntity.item_category]);
            if (existing_item_category) {
                return [
                    {
                        status: process.env.DUPLICATE_NAME,
                        message: process.env.ITEM_CATEGORY_EXIST,
                    }
                ];
            }
            const result = await this.connection.query('INSERT INTO item_category (item_category,is_active,description) VALUES (?,?,?)', [item_categoryEntity.item_category,
                item_categoryEntity.is_active,
                item_categoryEntity.description,
            ]);
            await this.dynamicConnection.query(`INSERT INTO item_category (item_category,is_active,description,Hospital_id,hospital_item_category_id) VALUES (?,?,?,?,?)`, [
                item_categoryEntity.item_category,
                item_categoryEntity.is_active,
                item_categoryEntity.description,
                item_categoryEntity.Hospital_id,
                result.insertId
            ]);
            return [{
                    "data ": {
                        "id  ": result.insertId,
                        "status": process.env.SUCCESS_STATUS_V2,
                        "messege": process.env.ITEM_CATEGORY,
                        "inserted_data": await this.connection.query('SELECT * FROM item_category WHERE id = ?', [result.insertId])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const item_category = await this.connection.query('SELECT * FROM item_category');
            return item_category;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM item_category WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const item_category = await this.connection.query('SELECT * FROM item_category WHERE id = ?', [id]);
            return item_category;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, item_categoryEntity) {
        const [existing_item_category] = await this.connection.query(`
      select id from item_category where id = ?`, [id]);
        if (!existing_item_category) {
            return [{ status: process.env.ERROR,
                    message: process.env.EXISTING_RECORD }];
        }
        try {
            await this.connection.query('UPDATE item_category SET item_category =?,  description =? WHERE id = ?', [item_categoryEntity.item_category,
                item_categoryEntity.description,
                id
            ]);
            await this.dynamicConnection.query('update item_category SET item_category =?,  description =?  where hospital_item_category_id = ? and Hospital_id= ?', [
                item_categoryEntity.item_category,
                item_categoryEntity.description,
                id,
                item_categoryEntity.Hospital_id
            ]);
            return [{
                    "data ": {
                        status: process.env.SUCCESS_STATUS_V2,
                        "messege": process.env.ITEM_CATEGORY_UPDATED,
                        "updated_values": await this.connection.query('SELECT * FROM item_category WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        const [existing_item_category] = await this.connection.query(`SELECT id FROM item_category WHERE id = ?`, [id]);
        if (!existing_item_category) {
            return [{ status: process.env.ERROR,
                    message: process.env.EXISTING_RECORD, }];
        }
        try {
            await this.connection.query('DELETE FROM item_category WHERE id = ?', [id]);
            const [admin] = await this.dynamicConnection.query(`select id from item_category where hospital_item_category_id = ?`, [id]);
            await this.dynamicConnection.query(`delete from item_category where id = ? and Hospital_id = ?`, [
                admin.id, Hospital_id
            ]);
            return [{
                    "status": process.env.SUCCESS_STATUS_V2,
                    "message": process.env.DELETED
                }
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async setupinventoryItemCategory(search) {
        let query = ` SELECT * FROM item_category `;
        let values = [];
        if (search) {
            query += ` WHERE ( item_category.item_category LIKE ? )  `;
            values.push('%' + search + '%');
        }
        let final = query;
        const setupinventoryItemCategorySearch = await this.connection.query(final, values);
        return setupinventoryItemCategorySearch;
    }
    async findALLitem_category(limit, page) {
        try {
            const offset = limit * (page - 1);
            const item_category = await this.connection.query(`select * from item_category LIMIT ? OFFSET ?`, [
                Number(limit), Number(offset)
            ]);
            let [totallist] = await this.connection.query(`select count(id) as total from item_category`);
            let variables = {
                details: item_category,
                total: totallist.total
            };
            return variables;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findInventoryItemCategorySearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
      SELECT * FROM item_category `;
            let countQuery = `
      SELECT COUNT(item_category.id) AS total FROM item_category `;
            if (search) {
                const condition = `
      WHERE item_category.item_category LIKE ? `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern);
            }
            baseQuery += ` ORDER BY item_category.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const ItemCategorySearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: ItemCategorySearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupInventoryItemCategoryService = SetupInventoryItemCategoryService;
exports.SetupInventoryItemCategoryService = SetupInventoryItemCategoryService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupInventoryItemCategoryService);
//# sourceMappingURL=setup-inventory-item_category.service.js.map