"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupHumanResourceSpecialistService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupHumanResourceSpecialistService = class SetupHumanResourceSpecialistService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(specialsitEntity) {
        const [existingspecialist] = await this.connection.query(`SELECT id FROM specialist WHERE LOWER(TRIM(specialist_name)) = LOWER(TRIM(?)) LIMIT 1`, [specialsitEntity.specialist_name]);
        if (existingspecialist) {
            return [
                {
                    status: process.env.DUPLICATE_NAME,
                    message: process.env.SPECIALIST_EXIST,
                },
            ];
        }
        try {
            const result = await this.connection.query('INSERT INTO specialist (specialist_name,is_active) VALUES (?,"yes")', [specialsitEntity.specialist_name]);
            try {
                await this.dynamicConnection.query(`INSERT INTO specialist (specialist_name,is_active,Hospital_id,hospital_specialist_id) VALUES (?,"yes",?,?)`, [
                    specialsitEntity.specialist_name,
                    specialsitEntity.Hospital_id,
                    result.insertId,
                ]);
            }
            catch (error) {
                throw new common_1.HttpException({
                    statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                    message: process.env.ERROR_MESSAGE,
                }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return [
                {
                    'data ': {
                        'id  ': result.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.SPECIALIST,
                        inserted_data: await this.connection.query('SELECT * FROM specialist WHERE id = ?', [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const specialsist = await this.connection.query('SELECT * FROM specialist');
            return specialsist;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM specialist WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const specialsist = await this.connection.query('SELECT * FROM specialist WHERE id = ?', [id]);
            return specialsist;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, specialsitEntity) {
        const [existingRecord] = await this.connection.query('SELECT id FROM specialist WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.ERROR,
                message: process.env.EXISTING_RECORD
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            await this.connection.query('UPDATE specialist SET specialist_name =? WHERE id = ?', [specialsitEntity.specialist_name, id]);
            await this.dynamicConnection.query('update specialist SET specialist_name =? where hospital_specialist_id = ? and Hospital_id =?', [specialsitEntity.specialist_name, id, specialsitEntity.Hospital_id]);
            return [
                {
                    'data ': {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.SPECIALIST_UPDATE,
                        updated_values: await this.connection.query('SELECT * FROM specialist WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM specialist WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.ERROR,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            if (Hospital_id) {
                try {
                    await this.connection.query('DELETE FROM specialist WHERE id = ?', [
                        id,
                    ]);
                    await this.dynamicConnection.query('delete from specialist where hospital_specialist_id = ? and Hospital_id = ?', [id, Hospital_id]);
                    return [
                        {
                            "status": process.env.SUCCESS_STATUS_V2,
                            "message": process.env.DELETED
                        },
                    ];
                }
                catch (error) {
                    throw new common_1.HttpException({
                        statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                        message: process.env.ERROR_MESSAGE,
                    }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
            else {
                return [
                    {
                        status: process.env.ERROR_STATUS,
                        message: process.env.HOSPITAL_ID_ERR_V2,
                    },
                ];
            }
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async HRSpecialist(search) {
        let query = ` SELECT * FROM specialist `;
        let values = [];
        if (search) {
            query += ` WHERE ( specialist.specialist_name LIKE ? )  `;
            values.push('%' + search + '%');
        }
        let final = query;
        const setupHRSpecialistSearch = await this.connection.query(final, values);
        return setupHRSpecialistSearch;
    }
    async findAllSpec(limit, page) {
        const offset = limit * (page - 1);
        const Specialist = await this.connection.query(`SELECT * FROM specialist LIMIT ? OFFSET ? `, [Number(limit), Number(offset)]);
        try {
            let [total_list] = await this.connection.query(`SELECT count(id) as total FROM specialist`);
            let out = {
                details: Specialist,
                total: total_list.total,
            };
            return out;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findSpecialistsearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
      SELECT * FROM specialist `;
            let countQuery = `
      SELECT COUNT(specialist.id) AS total 
      FROM specialist `;
            if (search) {
                const condition = `
      WHERE specialist.specialist_name LIKE ? `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern);
            }
            baseQuery += ` ORDER BY specialist.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const SpecialistSearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: SpecialistSearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupHumanResourceSpecialistService = SetupHumanResourceSpecialistService;
exports.SetupHumanResourceSpecialistService = SetupHumanResourceSpecialistService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupHumanResourceSpecialistService);
//# sourceMappingURL=setup-human_resource-specialist.service.js.map