"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupHumanResourcePayslipSettingsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupHumanResourcePayslipSettingsService = class SetupHumanResourcePayslipSettingsService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(payslip_setting_entity) {
        try {
            const [{ total_percentage }] = await this.connection.query(`SELECT COALESCE(SUM(default_percentage), 0) as total_percentage 
       FROM payslip_settings WHERE payslip_category_id = ? AND payslip_setting_name != 'Other Pay'`, [payslip_setting_entity.payslip_category_id]);
            const newTotalPercentage = Number(total_percentage) +
                Number(payslip_setting_entity.default_percentage);
            if (newTotalPercentage > 100) {
                throw new common_1.BadRequestException('Total Earning percentage cannot exceed 100%.');
            }
            const result = await this.connection.query(`INSERT INTO payslip_settings (payslip_category_id, payslip_setting_name, default_amount, default_percentage) 
       VALUES (?,?,?,?)`, [
                payslip_setting_entity.payslip_category_id,
                payslip_setting_entity.payslip_setting_name,
                payslip_setting_entity.default_amount,
                payslip_setting_entity.default_percentage,
            ]);
            const [payslip_category] = await this.dynamicConnection.query(`SELECT id FROM payslip_category WHERE hospital_id = ? AND hos_payslip_category_id = ?`, [
                payslip_setting_entity.hospital_id,
                payslip_setting_entity.payslip_category_id,
            ]);
            console.log('payslip_category', payslip_category.id, payslip_setting_entity.hospital_id, payslip_setting_entity.payslip_category_id);
            await this.dynamicConnection.query(`INSERT INTO payslip_settings (payslip_category_id, payslip_setting_name, default_amount, default_percentage, hospital_id, hos_payslip_settings_id) 
       VALUES (?,?,?,?,?,?)`, [
                payslip_category.id,
                payslip_setting_entity.payslip_setting_name,
                payslip_setting_entity.default_amount,
                payslip_setting_entity.default_percentage,
                payslip_setting_entity.hospital_id,
                result.insertId,
            ]);
            console.log('admin inserted', payslip_category.id, payslip_setting_entity.payslip_setting_name, payslip_setting_entity.default_amount, payslip_setting_entity.default_percentage, payslip_setting_entity.hospital_id, result.insertId);
            return [
                {
                    data: {
                        id: result.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        message: process.env.PAYSLIP_SETTING,
                        insertedData: await this.connection.query(`SELECT * FROM payslip_settings WHERE id = ?`, [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            if (error instanceof common_1.HttpException) {
                throw error;
            }
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const payslip_settings = await this.connection
                .query(`select payslip_settings.id,payslip_category.category_name as payslip_category_name,payslip_settings.payslip_setting_name,
payslip_settings.default_amount,payslip_settings.default_percentage 
from payslip_settings
left join payslip_category on payslip_settings.payslip_category_id = payslip_category.id`);
            return payslip_settings;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        try {
            const payslip_settings_id = await this.connection.query(`select payslip_settings.id,payslip_category.category_name as payslip_category_name,payslip_settings.payslip_setting_name,
      payslip_settings.default_amount,payslip_settings.default_percentage 
      from payslip_settings
      left join payslip_category on payslip_settings.payslip_category_id = payslip_category.id where payslip_settings.id = ?`, [id]);
            return payslip_settings_id;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, payslip_setting_entity) {
        try {
            const [{ total_percentage }] = await this.connection.query(`SELECT COALESCE(SUM(default_percentage), 0) as total_percentage 
       FROM payslip_settings 
       WHERE payslip_category_id = ? AND payslip_setting_name != 'Other Pay' AND id != ?`, [payslip_setting_entity.payslip_category_id, id]);
            const newTotalPercentage = Number(total_percentage) +
                Number(payslip_setting_entity.default_percentage);
            if (newTotalPercentage > 100) {
                throw new Error('Total Earning percentage cannot exceed 100%.');
            }
            await this.connection.query(`UPDATE payslip_settings 
       SET payslip_category_id = ?, payslip_setting_name = ?, default_amount = ?, default_percentage = ? 
       WHERE id = ?`, [
                payslip_setting_entity.payslip_category_id,
                payslip_setting_entity.payslip_setting_name,
                payslip_setting_entity.default_amount,
                payslip_setting_entity.default_percentage,
                id,
            ]);
            const [payslip_category_id] = await this.dynamicConnection.query(`select id from payslip_category where hospital_id = ? and hos_payslip_category_id = ?`, [
                payslip_setting_entity.hospital_id,
                payslip_setting_entity.payslip_category_id,
            ]);
            await this.dynamicConnection.query(`UPDATE payslip_settings 
       SET payslip_category_id = ?, payslip_setting_name = ?, default_amount = ?, default_percentage = ? 
       WHERE hos_payslip_settings_id = ? and hospital_id = ?`, [
                payslip_category_id.id,
                payslip_setting_entity.payslip_setting_name,
                payslip_setting_entity.default_amount,
                payslip_setting_entity.default_percentage,
                id,
                payslip_setting_entity.hospital_id,
            ]);
            return {
                status: process.env.SUCCESS_STATUS_V2,
                message: process.env.PAYSLIP_SETTING_UPDATED,
                'updated data': await this.connection.query(`SELECT * FROM payslip_settings WHERE id = ?`, [id]),
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, hospital_id) {
        try {
            await this.connection.query(`DELETE from payslip_settings where id = ?`, [
                id,
            ]);
            await this.dynamicConnection.query(`DELETE FROM payslip_settings where hos_payslip_settings_id = ? and hospital_id = ?`, [id, hospital_id]);
            return [
                {
                    "status": process.env.SUCCESS_STATUS_V2,
                    "message": process.env.DELETED
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAllPayrollSettings(limit, page) {
        const offset = limit * (page - 1);
        const payslip_setting = await this.connection.query(`SELECT * FROM payslip_settings LIMIT ? OFFSET ? `, [Number(limit), Number(offset)]);
        try {
            let [total_list] = await this.connection.query(`SELECT count(id) as total FROM payslip_settings`);
            let out = {
                details: payslip_setting,
                total: total_list.total,
            };
            return out;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findPayrollSettingsSearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
      select payslip_settings.id,payslip_category.category_name as payslip_category_name,payslip_settings.payslip_setting_name,
payslip_settings.default_amount,payslip_settings.default_percentage 
from payslip_settings
left join payslip_category on payslip_settings.payslip_category_id = payslip_category.id `;
            let countQuery = `
      SELECT COUNT(payslip_settings.id) AS total 
      FROM payslip_settings 
      left join payslip_category on payslip_settings.payslip_category_id = payslip_category.id`;
            if (search) {
                const condition = `
      WHERE payslip_category.category_name LIKE ? or payslip_settings.payslip_setting_name LIKE ? or payslip_settings.default_percentage LIKE ? `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern, pattern, pattern);
            }
            baseQuery += ` ORDER BY payslip_settings.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const PayslipSearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: PayslipSearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupHumanResourcePayslipSettingsService = SetupHumanResourcePayslipSettingsService;
exports.SetupHumanResourcePayslipSettingsService = SetupHumanResourcePayslipSettingsService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupHumanResourcePayslipSettingsService);
//# sourceMappingURL=setup-human_resource-payslip_settings.service.js.map