"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupHumanResourcePayslipSettingsController = void 0;
const common_1 = require("@nestjs/common");
const setup_human_resource_payslip_settings_service_1 = require("./setup-human_resource-payslip_settings.service");
const setup_human_resource_payslip_setting_entity_1 = require("./entities/setup-human_resource-payslip_setting.entity");
const auth_guard_1 = require("../auth/auth.guard");
let SetupHumanResourcePayslipSettingsController = class SetupHumanResourcePayslipSettingsController {
    constructor(setupHumanResourcePayslipSettingsService) {
        this.setupHumanResourcePayslipSettingsService = setupHumanResourcePayslipSettingsService;
    }
    create(payslip_setting_entity) {
        console.log('controller');
        return this.setupHumanResourcePayslipSettingsService.create(payslip_setting_entity);
    }
    findAll() {
        return this.setupHumanResourcePayslipSettingsService.findAll();
    }
    findOne(id) {
        return this.setupHumanResourcePayslipSettingsService.findOne(id);
    }
    update(id, payslip_setting_entity) {
        return this.setupHumanResourcePayslipSettingsService.update(+id, payslip_setting_entity);
    }
    remove(id, hospital_id) {
        return this.setupHumanResourcePayslipSettingsService.remove(id, hospital_id);
    }
    async findAllPayrollSettings(limit, page) {
        try {
            let final_out = await this.setupHumanResourcePayslipSettingsService.findAllPayrollSettings(limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE
            };
        }
    }
    async findPayrollSettingsSearch(search, limit, page) {
        try {
            let final_out = await this.setupHumanResourcePayslipSettingsService.findPayrollSettingsSearch(search, limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE
            };
        }
    }
};
exports.SetupHumanResourcePayslipSettingsController = SetupHumanResourcePayslipSettingsController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [setup_human_resource_payslip_setting_entity_1.SetupHumanResourcePayslipSetting]),
    __metadata("design:returntype", void 0)
], SetupHumanResourcePayslipSettingsController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SetupHumanResourcePayslipSettingsController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], SetupHumanResourcePayslipSettingsController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, setup_human_resource_payslip_setting_entity_1.SetupHumanResourcePayslipSetting]),
    __metadata("design:returntype", void 0)
], SetupHumanResourcePayslipSettingsController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", void 0)
], SetupHumanResourcePayslipSettingsController.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)("/v2/getAllPayrollSettings"),
    __param(0, (0, common_1.Query)("limit")),
    __param(1, (0, common_1.Query)("page")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], SetupHumanResourcePayslipSettingsController.prototype, "findAllPayrollSettings", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)("/v2/SetupHRPayrollSettings"),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)("limit")),
    __param(2, (0, common_1.Query)("page")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number]),
    __metadata("design:returntype", Promise)
], SetupHumanResourcePayslipSettingsController.prototype, "findPayrollSettingsSearch", null);
exports.SetupHumanResourcePayslipSettingsController = SetupHumanResourcePayslipSettingsController = __decorate([
    (0, common_1.Controller)('setup-human-resource-payslip-settings'),
    __metadata("design:paramtypes", [setup_human_resource_payslip_settings_service_1.SetupHumanResourcePayslipSettingsService])
], SetupHumanResourcePayslipSettingsController);
//# sourceMappingURL=setup-human_resource-payslip_settings.controller.js.map