"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupHumanResourcePayslipCategoryService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupHumanResourcePayslipCategoryService = class SetupHumanResourcePayslipCategoryService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(payslip_categoryEntity) {
        try {
            const payslip_category = await this.connection.query(` insert into payslip_category (category_name) values (?)`, [
                payslip_categoryEntity.category_name
            ]);
            await this.dynamicConnection.query(`insert into payslip_category (category_name, hospital_id, hos_payslip_category_id) values (?,?,?)`, [
                payslip_categoryEntity.category_name,
                payslip_categoryEntity.hospital_id,
                payslip_category.insertId
            ]);
            return [{ "data": { "id": payslip_category.insertId,
                        "status": process.env.SUCCESS_STATUS_V2,
                        "message": process.env.PAYSLIP_CATEGORY,
                        "inserted_data": await this.connection.query('SELECT * FROM payslip_category where id = ?', [payslip_category.insertId])
                    } }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const payslip_Entity = await this.connection.query(`select * from payslip_category`);
            return payslip_Entity;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findone(id) {
        try {
            const payslip_entity_id = await this.connection.query(`select * from payslip_category where id = ?`, [id]);
            return payslip_entity_id;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, payslip_categoryEntity) {
        try {
            await this.connection.query(`update payslip_category SET category_name = ?
    where id = ?`, [
                payslip_categoryEntity.category_name,
                id
            ]);
            await this.dynamicConnection.query(`
      update payslip_category SET category_name = ? where hos_payslip_category_id = ? and hospital_id = ?`, [
                payslip_categoryEntity.category_name,
                id,
                payslip_categoryEntity.hospital_id
            ]);
            return [{ "data": {
                        status: process.env.SUCCESS_STATUS_V2,
                        "message": process.env.PAYSLIP_CATEGORY_UPDATED,
                        "updated_values": await this.connection.query(`select * from payslip_category where id = ?`, [id])
                    } }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, hospital_id) {
        try {
            await this.connection.query(`delete from payslip_category where id = ?`, [id]);
            console.log("deleted");
            await this.dynamicConnection.query(`delete from payslip_category where hos_payslip_category_id = ? and hospital_id = ?`, [
                id,
                hospital_id
            ]);
            console.log("admin deleted");
            return [{ "data": {
                        status: process.env.SUCCESS_STATUS_V2,
                        "message": process.env.DELETED
                    } }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupHumanResourcePayslipCategoryService = SetupHumanResourcePayslipCategoryService;
exports.SetupHumanResourcePayslipCategoryService = SetupHumanResourcePayslipCategoryService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupHumanResourcePayslipCategoryService);
//# sourceMappingURL=setup-human_resource-payslip_category.service.js.map