"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupHumanResourceDesignationService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupHumanResourceDesignationService = class SetupHumanResourceDesignationService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(designationEntity) {
        const [existingUnitType] = await this.connection.query(`SELECT id FROM staff_designation WHERE LOWER(TRIM(designation)) = LOWER(TRIM(?)) LIMIT 1`, [designationEntity.designation]);
        if (existingUnitType) {
            return [
                {
                    status: process.env.DUPLICATE_NAME,
                    message: process.env.DESIGNATION_EXIST,
                },
            ];
        }
        try {
            const result = await this.connection.query('INSERT INTO staff_designation (designation,is_active) VALUES (?,?)', [designationEntity.designation, designationEntity.is_active]);
            await this.dynamicConnection.query('INSERT INTO staff_designation(designation,is_active,Hospital_id,hospital_staff_designation_id) values (?,?,?,?)', [
                designationEntity.designation,
                designationEntity.is_active,
                designationEntity.Hospital_id,
                result.insertId,
            ]);
            return [
                {
                    'data ': {
                        'id  ': result.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.DESIGNATION,
                        inserted_data: await this.connection.query('SELECT * FROM staff_designation WHERE id = ?', [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const staff_designation = await this.connection.query('SELECT * FROM staff_designation');
            return staff_designation;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM staff_designation WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const staff_designation = await this.connection.query('SELECT * FROM staff_designation WHERE id = ?', [id]);
            return staff_designation;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, designationEntity) {
        const [existingRecord] = await this.connection.query('SELECT id FROM staff_designation WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.ERROR,
                message: process.env.EXISTING_RECORD
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            await this.connection.query('UPDATE staff_designation SET designation =? WHERE id = ?', [designationEntity.designation, id]);
            await this.dynamicConnection.query(`update staff_designation SET designation = ? WHERE hospital_staff_designation_id = ? and Hospital_id = ?`, [designationEntity.designation, id, designationEntity.Hospital_id]);
            return [
                {
                    'data ': {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.DESIGNATION_UPDATED,
                        updated_values: await this.connection.query('SELECT * FROM staff_designation WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM staff_designation WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.ERROR,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            if (Hospital_id) {
                try {
                    await this.connection.query('DELETE FROM staff_designation WHERE id = ?', [id]);
                    await this.dynamicConnection.query('delete from staff_designation where hospital_staff_designation_id = ? and Hospital_id = ?', [id, Hospital_id]);
                    return [
                        {
                            "status": process.env.SUCCESS_STATUS_V2,
                            "message": process.env.DELETED
                        },
                    ];
                }
                catch (error) {
                    return error;
                }
            }
            else {
                return [
                    {
                        status: process.env.ERROR_STATUS,
                        message: process.env.HOSPITAL_ID_ERR_V2
                    },
                ];
            }
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async HRDesignation(search) {
        let query = ` SELECT * FROM staff_designation `;
        let values = [];
        if (search) {
            query += ` WHERE ( staff_designation.designation LIKE ? )  `;
            values.push('%' + search + '%');
        }
        let final = query;
        const setupHRDesignationSearch = await this.connection.query(final, values);
        return setupHRDesignationSearch;
    }
    async findAllDesig(limit, page) {
        const offset = limit * (page - 1);
        const staff_designation = await this.connection.query(`SELECT * FROM staff_designation LIMIT ? OFFSET ? `, [Number(limit), Number(offset)]);
        try {
            let [total_list] = await this.connection.query(`SELECT count(id) as total FROM staff_designation`);
            let out = {
                details: staff_designation,
                total: total_list.total,
            };
            return out;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findDesignationsearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
        SELECT * FROM staff_designation `;
            let countQuery = `
        SELECT COUNT(staff_designation.id) AS total 
        FROM staff_designation `;
            if (search) {
                const condition = `
      WHERE staff_designation.designation LIKE ? `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern);
            }
            baseQuery += ` ORDER BY staff_designation.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const DesignationSearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: DesignationSearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupHumanResourceDesignationService = SetupHumanResourceDesignationService;
exports.SetupHumanResourceDesignationService = SetupHumanResourceDesignationService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupHumanResourceDesignationService);
//# sourceMappingURL=setup-human_resource-designation.service.js.map