"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupHumanResourceDepartmentService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupHumanResourceDepartmentService = class SetupHumanResourceDepartmentService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(departmentEntity) {
        try {
            const [existingUnitType] = await this.connection.query(`SELECT id FROM department WHERE LOWER(TRIM(department_name)) = LOWER(TRIM(?)) LIMIT 1`, [departmentEntity.department_name]);
            if (existingUnitType) {
                return [
                    {
                        status: process.env.DUPLICATE_NAME,
                        message: process.env.EXISTING_RECORD,
                    },
                ];
            }
            const result = await this.connection.query('INSERT INTO department (department_name,is_active) VALUES (?,?)', [departmentEntity.department_name, departmentEntity.is_active]);
            await this.dynamicConnection.query('INSERT INTO department (department_name,is_active,Hospital_id,hospital_department_id) values (?,?,?,?)', [
                departmentEntity.department_name,
                departmentEntity.is_active,
                departmentEntity.Hospital_id,
                result.insertId,
            ]);
            return [
                {
                    'data ': {
                        'id  ': result.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.DEPARTMENT,
                        inserted_data: await this.connection.query('SELECT * FROM department WHERE id = ?', [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const department = await this.connection.query('SELECT * FROM department');
            return department;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM department WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const department = await this.connection.query('SELECT * FROM department WHERE id = ?', [id]);
            return department;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, departmentEntity) {
        const [existingRecord] = await this.connection.query('SELECT id FROM department WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.ERROR,
                message: process.env.EXISTING_RECORD
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            await this.connection.query('UPDATE department SET department_name =? WHERE id = ?', [departmentEntity.department_name, id]);
            await this.dynamicConnection.query('update department SET department_name = ? where hospital_department_id = ? and Hospital_id= ?', [departmentEntity.department_name, id, departmentEntity.Hospital_id]);
            return [
                {
                    'data ': {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.DEPARTMENT_UPDATED,
                        updated_values: await this.connection.query('SELECT * FROM department WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM department WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.ERROR,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            if (Hospital_id) {
                try {
                    await this.connection.query('DELETE FROM department WHERE id = ?', [
                        id,
                    ]);
                    const [depart] = await this.dynamicConnection.query(`select id from department where hospital_department_id = ? and Hospital_id = ?`, [id, Hospital_id]);
                    await this.dynamicConnection.query(`delete from department where id = ? `, [depart.id]);
                    return [
                        {
                            status: process.env.SUCCESS_STATUS_V2,
                            message: process.env.DELETED
                        },
                    ];
                }
                catch (error) {
                    throw new common_1.HttpException({
                        statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                        message: process.env.ERROR_MESSAGE,
                    }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
            else {
                return [
                    {
                        status: process.env.ERROR_STATUS,
                        message: process.env.HOSPITAL_ID_ERR_V2,
                    },
                ];
            }
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async HRDepartment(search) {
        let query = ` SELECT * FROM department `;
        let values = [];
        if (search) {
            query += ` WHERE ( department.department_name LIKE ? )  `;
            values.push('%' + search + '%');
        }
        let final = query;
        const setupHRDepartmentSearch = await this.connection.query(final, values);
        return setupHRDepartmentSearch;
    }
    async findAllDepart(limit, page) {
        const offset = limit * (page - 1);
        const staff_department = await this.connection.query(`SELECT * FROM department LIMIT ? OFFSET ? `, [Number(limit), Number(offset)]);
        try {
            let [total_list] = await this.connection.query(`SELECT count(id) as total FROM department`);
            let out = {
                details: staff_department,
                total: total_list.total,
            };
            return out;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findDepartmentsearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
      SELECT * FROM department `;
            let countQuery = `
      SELECT COUNT(department.id) AS total 
      FROM department `;
            if (search) {
                const condition = `
      WHERE department.department_name LIKE ? `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern);
            }
            baseQuery += ` ORDER BY department.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const DepartmentSearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: DepartmentSearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupHumanResourceDepartmentService = SetupHumanResourceDepartmentService;
exports.SetupHumanResourceDepartmentService = SetupHumanResourceDepartmentService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupHumanResourceDepartmentService);
//# sourceMappingURL=setup-human_resource-department.service.js.map