"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupHumanResourceDepartmentController = void 0;
const common_1 = require("@nestjs/common");
const setup_human_resource_department_service_1 = require("./setup-human_resource-department.service");
const setup_human_resource_department_entity_1 = require("./entities/setup-human_resource-department.entity");
const auth_guard_1 = require("../auth/auth.guard");
let SetupHumanResourceDepartmentController = class SetupHumanResourceDepartmentController {
    constructor(setupHumanResourceDepartmentService) {
        this.setupHumanResourceDepartmentService = setupHumanResourceDepartmentService;
    }
    create(departmentEntity) {
        return this.setupHumanResourceDepartmentService.create(departmentEntity);
    }
    findAll() {
        return this.setupHumanResourceDepartmentService.findAll();
    }
    findOne(id) {
        return this.setupHumanResourceDepartmentService.findOne(id);
    }
    update(id, departmentEntity) {
        return this.setupHumanResourceDepartmentService.update(id, departmentEntity);
    }
    async remove(id, Hospital_id) {
        const deletedepart = await this.setupHumanResourceDepartmentService.remove(id, Hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    HRDepartment(search) {
        console.log(search, 'zzzzzz');
        return this.setupHumanResourceDepartmentService.HRDepartment(search);
    }
    async findAllDepart(limit, page) {
        try {
            let final_out = await this.setupHumanResourceDepartmentService.findAllDepart(limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE
            };
        }
    }
    async findDepartmentsearch(search, limit, page) {
        try {
            let final_out = await this.setupHumanResourceDepartmentService.findDepartmentsearch(search, limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE
            };
        }
    }
};
exports.SetupHumanResourceDepartmentController = SetupHumanResourceDepartmentController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [setup_human_resource_department_entity_1.SetupHumanResourceDepartment]),
    __metadata("design:returntype", void 0)
], SetupHumanResourceDepartmentController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SetupHumanResourceDepartmentController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SetupHumanResourceDepartmentController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, setup_human_resource_department_entity_1.SetupHumanResourceDepartment]),
    __metadata("design:returntype", void 0)
], SetupHumanResourceDepartmentController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", Promise)
], SetupHumanResourceDepartmentController.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/SetupHRDepartment/:search'),
    __param(0, (0, common_1.Param)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SetupHumanResourceDepartmentController.prototype, "HRDepartment", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)("/v2/getAllDepart"),
    __param(0, (0, common_1.Query)("limit")),
    __param(1, (0, common_1.Query)("page")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], SetupHumanResourceDepartmentController.prototype, "findAllDepart", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)("/v2/SetupHRDepartment"),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)("limit")),
    __param(2, (0, common_1.Query)("page")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number]),
    __metadata("design:returntype", Promise)
], SetupHumanResourceDepartmentController.prototype, "findDepartmentsearch", null);
exports.SetupHumanResourceDepartmentController = SetupHumanResourceDepartmentController = __decorate([
    (0, common_1.Controller)('setup-human-resource-department'),
    __metadata("design:paramtypes", [setup_human_resource_department_service_1.SetupHumanResourceDepartmentService])
], SetupHumanResourceDepartmentController);
//# sourceMappingURL=setup-human_resource-department.controller.js.map