"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupHospitalChargesChargeTypeModuleService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupHospitalChargesChargeTypeModuleService = class SetupHospitalChargesChargeTypeModuleService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(charge_type_moduleEntity) {
        try {
            const [check] = await this.connection.query(`select id from charge_type_module where charge_type_master_id = ? and module_shortcode =?`, [
                charge_type_moduleEntity.charge_type_master_id, charge_type_moduleEntity.module_shortcode
            ]);
            if (check) {
                const [getadmin] = await this.dynamicConnection.query(`select id from charge_type_module where Hospital_id =? and hospital_charge_type_module_id = ?`, [
                    charge_type_moduleEntity.Hospital_id, check.id
                ]);
                await this.dynamicConnection.query(`delete from charge_type_module where id = ?`, [getadmin.id]);
                await this.connection.query(`delete from charge_type_module where id = ?`, [check.id]);
                return [{
                        "data": {
                            status: process.env.SUCCESS_STATUS_V2,
                            message: process.env.DELETED
                        }
                    }];
            }
            else {
                const result = await this.connection.query('INSERT INTO charge_type_module (charge_type_master_id,module_shortcode) VALUES (?,?)', [charge_type_moduleEntity.charge_type_master_id,
                    charge_type_moduleEntity.module_shortcode,
                ]);
                const [getAdminMaster] = await this.dynamicConnection.query(`select id from charge_type_master where
      hospital_charge_type_master_id = ? and
      Hospital_id = ?
     `, [
                    charge_type_moduleEntity.charge_type_master_id,
                    charge_type_moduleEntity.Hospital_id
                ]);
                await this.dynamicConnection.query('INSERT INTO charge_type_module (charge_type_master_id,module_shortcode,Hospital_id,hospital_charge_type_module_id) VALUES (?,?,?,?)', [
                    getAdminMaster.id,
                    charge_type_moduleEntity.module_shortcode,
                    charge_type_moduleEntity.Hospital_id,
                    result.insertId
                ]);
                return [{
                        "data ": {
                            "id  ": result.insertId,
                            status: process.env.SUCCESS_STATUS_V2,
                            messege: process.env.CHARGE_TYPE_MODULE,
                            "inserted_data": await this.connection.query('SELECT * FROM charge_type_module WHERE id = ?', [result.insertId])
                        }
                    }];
            }
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const q = `SELECT
    charge_type_master.id,
    charge_type_master.charge_type AS charge_type,
    JSON_ARRAYAGG(
        JSON_OBJECT(
            'id', charge_type_module.id,
            'module_shortcode', charge_type_module.module_shortcode
        )
    ) AS modules
  FROM charge_type_master
  LEFT JOIN charge_type_module ON charge_type_module.charge_type_master_id = charge_type_master.id
  GROUP BY charge_type_master.id;
  `;
            const charge_type_modules = await this.connection.query(q);
            const predefinedModules = ['appointment', 'ipd', 'opd', 'pathology', 'radiology', 'bloodbank', 'ambulance'];
            const mapModules = (modules) => {
                return predefinedModules.reduce((acc, moduleName) => {
                    const module = modules.find((module) => module.module_shortcode === moduleName);
                    const id = module ? module.id : null;
                    acc[moduleName] = { id, value: !!module };
                    return acc;
                }, {});
            };
            const formattedResults = charge_type_modules.map(chargeTypeModule => {
                return {
                    id: chargeTypeModule.id,
                    charge_type: chargeTypeModule.charge_type,
                    modules: Array.isArray(chargeTypeModule.modules)
                        ? mapModules(chargeTypeModule.modules)
                        : {},
                };
            });
            return formattedResults;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM charge_type_module WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const charge_type_module = await this.connection.query('SELECT * FROM charge_type_module WHERE id = ?', [id]);
            return charge_type_module;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupHospitalChargesChargeTypeModuleService = SetupHospitalChargesChargeTypeModuleService;
exports.SetupHospitalChargesChargeTypeModuleService = SetupHospitalChargesChargeTypeModuleService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupHospitalChargesChargeTypeModuleService);
//# sourceMappingURL=setup-hospital-charges_charge_type_module.service.js.map