"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupHospitalChargesChargeTypeMasterService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupHospitalChargesChargeTypeMasterService = class SetupHospitalChargesChargeTypeMasterService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(charge_type_masterEntity) {
        try {
            const result = await this.connection.query('INSERT INTO charge_type_master (charge_type,is_default,is_active) VALUES (?,?,?)', [
                charge_type_masterEntity.charge_type,
                charge_type_masterEntity.is_default,
                charge_type_masterEntity.is_active,
            ]);
            await this.dynamicConnection.query(`INSERT INTO charge_type_master (charge_type,is_default,is_active,
      Hospital_id,hospital_charge_type_master_id) VALUES (?,?,?,?,?)`, [
                charge_type_masterEntity.charge_type,
                charge_type_masterEntity.is_default,
                charge_type_masterEntity.is_active,
                charge_type_masterEntity.Hospital_id,
                result.insertId,
            ]);
            return [
                {
                    data: {
                        id: result.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.CHARGE_TYPE_MASTER,
                        inserted_data: await this.connection.query('SELECT * FROM charge_type_master WHERE id = ?', [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const charge_type_master = await this.connection.query('SELECT * FROM charge_type_master');
            return charge_type_master;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingRecord] = await this.connection.query('SELECT * FROM charge_type_master WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const charge_type_master = await this.connection.query('SELECT * FROM charge_type_master WHERE id = ?', [id]);
            return charge_type_master;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, charge_type_masterEntity) {
        const [existingRecord] = await this.connection.query('SELECT id FROM charge_type_master WHERE id = ?', [id]);
        if (!existingRecord) {
            return [{ status: process.env.ERROR,
                    message: process.env.EXISTING_RECORD }];
        }
        try {
            await this.connection.query('UPDATE charge_type_master SET charge_type =?,  is_default =?,  is_active =? WHERE id = ?', [
                charge_type_masterEntity.charge_type,
                charge_type_masterEntity.is_default,
                charge_type_masterEntity.is_active,
                id,
            ]);
            await this.dynamicConnection.query('update charge_type_master SET charge_type = ?, is_default = ?, is_active= ? where hospital_charge_type_master_id = ? and Hospital_id = ? ', [
                charge_type_masterEntity.charge_type,
                charge_type_masterEntity.is_default,
                charge_type_masterEntity.is_active,
                id,
                charge_type_masterEntity.Hospital_id,
            ]);
            return [
                {
                    'data ': {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.CHARGE_TYPE_MASTER_UPDATED,
                        updated_values: await this.connection.query('SELECT * FROM charge_type_master WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM charge_type_master WHERE id = ?', [id]);
        if (!existingRecord) {
            return [{ status: process.env.ERROR,
                    message: process.env.EXISTING_RECORD }];
        }
        try {
            await this.connection.query('DELETE FROM charge_type_master WHERE id = ?', [id]);
            const charge_type = await this.dynamicConnection.query(`select id from charge_type_master where hospital_charge_type_master_id = ?`, [id]);
            const type = charge_type[0].id;
            await this.dynamicConnection.query(`delete from charge_type_master where id = ? and Hospital_id = ?`, [type, Hospital_id]);
            return [
                {
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DELETED
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async HospitalChargesChargeType(search) {
        let query = ` SELECT * FROM charge_type_master `;
        let values = [];
        if (search) {
            query += ` WHERE ( charge_type_master.charge_type LIKE ? )  `;
            values.push('%' + search + '%');
        }
        let final = query;
        const setupHospitalChargesChargeTypeSearch = await this.connection.query(final, values);
        return setupHospitalChargesChargeTypeSearch;
    }
    async findALL_charge_type_master(limit, page, search) {
        try {
            const offset = limit * (page - 1);
            let dateCondition = '';
            let searchClause = '';
            if (search) {
                const searchClause = `(
        charge_type_master.charge_type LIKE '%${search}%' 
        )`;
                dateCondition = ` AND ${searchClause}`;
            }
            const charge_type_master = await this.connection.query(`SELECT * FROM charge_type_master WHERE charge_type_master.id ${dateCondition} LIMIT ? OFFSET ?`, [Number(limit), Number(offset)]);
            let [total_list] = await this.connection.query(`select count(id) as total from charge_type_master WHERE charge_type_master.id ${dateCondition}`);
            let variables = {
                details: charge_type_master,
                total: total_list.total,
                page: page,
                limit: limit
            };
            return variables;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupHospitalChargesChargeTypeMasterService = SetupHospitalChargesChargeTypeMasterService;
exports.SetupHospitalChargesChargeTypeMasterService = SetupHospitalChargesChargeTypeMasterService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupHospitalChargesChargeTypeMasterService);
//# sourceMappingURL=setup-hospital-charges_charge_type_master.service.js.map