"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupHospitalChargesChargeTypeMasterController = void 0;
const common_1 = require("@nestjs/common");
const setup_hospital_charges_charge_type_master_service_1 = require("./setup-hospital-charges_charge_type_master.service");
const setup_hospital_charges_charge_type_master_entity_1 = require("./entities/setup-hospital-charges_charge_type_master.entity");
const auth_guard_1 = require("../auth/auth.guard");
let SetupHospitalChargesChargeTypeMasterController = class SetupHospitalChargesChargeTypeMasterController {
    constructor(setupHospitalChargesChargeTypeMasterService) {
        this.setupHospitalChargesChargeTypeMasterService = setupHospitalChargesChargeTypeMasterService;
    }
    create(charge_type_masterEntity) {
        return this.setupHospitalChargesChargeTypeMasterService.create(charge_type_masterEntity);
    }
    findAll() {
        return this.setupHospitalChargesChargeTypeMasterService.findAll();
    }
    findOne(id) {
        return this.setupHospitalChargesChargeTypeMasterService.findOne(id);
    }
    update(id, charge_type_masterEntity) {
        return this.setupHospitalChargesChargeTypeMasterService.update(id, charge_type_masterEntity);
    }
    async remove(id, Hospital_id) {
        return this.setupHospitalChargesChargeTypeMasterService.remove(id, Hospital_id);
    }
    HospitalChargesChargeType(search) {
        return this.setupHospitalChargesChargeTypeMasterService.HospitalChargesChargeType(search);
    }
    async findallcharge_type_master(limit, page, search) {
        try {
            let final_output = await this.setupHospitalChargesChargeTypeMasterService.findALL_charge_type_master(limit || 10, page || 1, search || '');
            if (final_output.details.length) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output.details,
                    total: final_output.total,
                    limit: final_output.limit,
                    totalpages: Math.ceil(final_output.total / final_output.limit)
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE
            };
        }
        return this.setupHospitalChargesChargeTypeMasterService.findALL_charge_type_master(limit, page, search);
    }
};
exports.SetupHospitalChargesChargeTypeMasterController = SetupHospitalChargesChargeTypeMasterController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [setup_hospital_charges_charge_type_master_entity_1.SetupHospitalChargesChargeTypeMaster]),
    __metadata("design:returntype", void 0)
], SetupHospitalChargesChargeTypeMasterController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SetupHospitalChargesChargeTypeMasterController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SetupHospitalChargesChargeTypeMasterController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, setup_hospital_charges_charge_type_master_entity_1.SetupHospitalChargesChargeTypeMaster]),
    __metadata("design:returntype", void 0)
], SetupHospitalChargesChargeTypeMasterController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", Promise)
], SetupHospitalChargesChargeTypeMasterController.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/SetupHospitalChargesChargeType/:search'),
    __param(0, (0, common_1.Param)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SetupHospitalChargesChargeTypeMasterController.prototype, "HospitalChargesChargeType", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/getAllcharge_type_master'),
    __param(0, (0, common_1.Query)('limit')),
    __param(1, (0, common_1.Query)('page')),
    __param(2, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String]),
    __metadata("design:returntype", Promise)
], SetupHospitalChargesChargeTypeMasterController.prototype, "findallcharge_type_master", null);
exports.SetupHospitalChargesChargeTypeMasterController = SetupHospitalChargesChargeTypeMasterController = __decorate([
    (0, common_1.Controller)('setup-hospital-charges-charge-type-master'),
    __metadata("design:paramtypes", [setup_hospital_charges_charge_type_master_service_1.SetupHospitalChargesChargeTypeMasterService])
], SetupHospitalChargesChargeTypeMasterController);
//# sourceMappingURL=setup-hospital-charges_charge_type_master.controller.js.map