"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupFindingsFindingService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupFindingsFindingService = class SetupFindingsFindingService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(findingEntity) {
        try {
            const [existingExpense] = await this.connection.query(`
        SELECT id FROM finding WHERE name = ? LIMIT 1`, [findingEntity.name]);
            if (existingExpense) {
                return [{
                        status: process.env.DUPLICATE_NAME,
                        message: process.env.FINDING_EXIST
                    }];
            }
            const result = await this.connection.query('INSERT INTO finding (name,description,finding_category_id) VALUES (?,?,?)', [
                findingEntity.name,
                findingEntity.description,
                findingEntity.finding_category_id,
            ]);
            const [finding_category] = await this.dynamicConnection.query(`select id from finding_category where Hospital_id = ? and hospital_finding_category_id = ?`, [findingEntity.Hospital_id, findingEntity.finding_category_id]);
            await this.dynamicConnection.query('insert into finding (name,description,finding_category_id,Hospital_id,hospital_finding_id) values (?,?,?,?,?)', [
                findingEntity.name,
                findingEntity.description,
                finding_category.id,
                findingEntity.Hospital_id,
                result.insertId,
            ]);
            return [
                {
                    'data ': {
                        'id  ': result.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.FINDING,
                        inserted_data: await this.connection.query('SELECT * FROM finding WHERE id = ?', [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const finding = await this.connection
                .query(`select finding.id,finding.name,finding.description,finding_category.category from finding 
    join finding_category ON finding.finding_category_id = finding_category.id`);
            return finding;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM finding WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const finding = await this.connection.query(`select finding.id,finding.name,finding.description,finding_category.category from finding 
  join finding_category ON finding.finding_category_id = finding_category.id WHERE finding.id = ?`, [id]);
            return finding;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, findingEntity) {
        const [existingRecord] = await this.connection.query('SELECT id FROM finding WHERE id = ?', [id]);
        if (!existingRecord) {
            return [{ status: process.env.ERROR,
                    message: process.env.EXISTING_RECORD }];
        }
        try {
            await this.connection.query('UPDATE finding SET name =?,description =?,finding_category_id =?  WHERE id = ?', [
                findingEntity.name,
                findingEntity.description,
                findingEntity.finding_category_id,
                id,
            ]);
            await this.dynamicConnection.query('update finding SET  name =?,description =?,finding_category_id =? where hospital_finding_id = ? and Hospital_id = ?', [
                findingEntity.name,
                findingEntity.description,
                findingEntity.finding_category_id,
                id,
                findingEntity.Hospital_id,
            ]);
            return [
                {
                    'data ': {
                        status: process.env.SUCCESS_STATUS_V2,
                        message: process.env.FINDING_UPDATED,
                        updated_values: await this.connection.query('SELECT * FROM finding WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM finding WHERE id = ?', [id]);
        if (!existingRecord) {
            return [{ status: process.env.ERROR,
                    message: process.env.EXISTING_RECORD }];
        }
        try {
            await this.connection.query('DELETE FROM finding WHERE id = ?', [id]);
            const [finding] = await this.dynamicConnection.query(`select id from finding where hospital_finding_id = ?`, [id]);
            await this.dynamicConnection.query(`delete from finding where id = ? and Hospital_id = ?`, [finding.id, Hospital_id]);
            return [
                {
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DELETED
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async setupFinding(search) {
        let query = ` select finding.id,finding.name,finding.description,finding_category.category from finding 
    join finding_category ON finding.finding_category_id = finding_category.id `;
        let values = [];
        if (search) {
            query += ` WHERE ( finding.name LIKE ? OR finding_category.category LIKE ? OR finding.description LIKE ? )  `;
            values.push('%' + search + '%');
            values.push('%' + search + '%');
            values.push('%' + search + '%');
        }
        let final = query;
        const Setupfinding = await this.connection.query(final, values);
        return Setupfinding;
    }
    async find_findings(limit, page, search) {
        try {
            const offset = limit * (page - 1);
            let whereClause = 'WHERE 1=1';
            if (search) {
                whereClause += ` AND (
        finding.name LIKE '%${search}%' OR
        finding_category.category LIKE '%${search}%' OR
        finding.description LIKE '%${search}%'
      )`;
            }
            const findings = await this.connection.query(`SELECT finding.id AS id, finding.name AS name, finding.description AS description,
        finding.finding_category_id AS finding_category_id,
        finding_category.category AS finding_category 
      FROM finding
      LEFT JOIN finding_category ON finding.finding_category_id = finding_category.id 
      ${whereClause}
      LIMIT ? OFFSET ?`, [Number(limit), Number(offset)]);
            const [totallist] = await this.connection.query(`SELECT COUNT(finding.id) AS total 
       FROM finding 
       LEFT JOIN finding_category ON finding.finding_category_id = finding_category.id 
       ${whereClause}`);
            return {
                details: findings,
                total: totallist.total,
                page: page,
                limit: limit
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupFindingsFindingService = SetupFindingsFindingService;
exports.SetupFindingsFindingService = SetupFindingsFindingService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupFindingsFindingService);
//# sourceMappingURL=setup-findings-finding.service.js.map