"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupFinanceIncomeHeadService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupFinanceIncomeHeadService = class SetupFinanceIncomeHeadService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(income_headEntity) {
        try {
            const [existingUnitType] = await this.connection.query(`SELECT id FROM income_head WHERE LOWER(TRIM(income_category)) = LOWER(TRIM(?)) LIMIT 1`, [income_headEntity.income_category]);
            if (existingUnitType) {
                return [
                    {
                        status: process.env.DUPLICATE_NAME,
                        message: process.env.INCOME_HEAD_EXIST,
                    },
                ];
            }
            const result = await this.connection.query('INSERT INTO income_head (income_category,description,is_active,is_deleted) VALUES (?,?,?,?)', [
                income_headEntity.income_category,
                income_headEntity.description,
                income_headEntity.is_active,
                income_headEntity.is_deleted,
            ]);
            await this.dynamicConnection.query('insert into income_head (income_category,description,is_active,is_deleted,Hospital_id,hospital_income_head_id) values (?,?,?,?,?,?)', [
                income_headEntity.income_category,
                income_headEntity.description,
                income_headEntity.is_active,
                income_headEntity.is_deleted,
                income_headEntity.Hospital_id,
                result.insertId,
            ]);
            return [
                {
                    'data ': {
                        'id  ': result.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.INCOME_HEAD,
                        inserted_data: await this.connection.query('SELECT * FROM income_head WHERE id = ?', [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const income_head = await this.connection.query('SELECT * FROM income_head');
            return income_head;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingincome] = await this.connection.query(`select id from income_head where id = ?`, [id]);
        if (!existingincome || existingincome.length == 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const income_head = await this.connection.query('SELECT * FROM income_head WHERE id = ?', [id]);
            return income_head;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, income_headEntity) {
        const [existingincome] = await this.connection.query(`select id from income_head where id = ?`, [id]);
        if (!existingincome || existingincome.length == 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            await this.connection.query('UPDATE income_head SET income_category =?, description =? WHERE id = ?', [income_headEntity.income_category, income_headEntity.description, id]);
            await this.dynamicConnection.query('update income_head SET  income_category =?, description =? where hospital_income_head_id = ? and Hospital_id = ? ', [
                income_headEntity.income_category,
                income_headEntity.description,
                id,
                income_headEntity.Hospital_id,
            ]);
            return [
                {
                    'data ': {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.INCOME_HEAD_UPDATED,
                        updated_values: await this.connection.query('SELECT * FROM income_head WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        const [existingincome] = await this.connection.query(`select id from income_head where id = ?`, [id]);
        if (!existingincome || existingincome.length == 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            await this.connection.query('DELETE FROM income_head WHERE id = ?', [id]);
            const [expense_head] = await this.dynamicConnection.query(`select id from income_head where hospital_income_head_id = ?`, [id]);
            await this.dynamicConnection.query(`delete from income_head where id = ? and Hospital_id = ?`, [expense_head.id, Hospital_id]);
            return [
                {
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DELETED
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async SetupIncomehead(search) {
        try {
            let query = ` SELECT * FROM income_head `;
            let values = [];
            if (search) {
                query += ` WHERE ( income_head.income_category LIKE ? )  `;
                values.push('%' + search + '%');
            }
            let final = query;
            const setupIncomehead = await this.connection.query(final, values);
            return setupIncomehead;
        }
        catch (error) {
            throw new common_1.HttpException({
                statuscode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findALLincome_head(limit, page) {
        try {
            const offset = limit * (page - 1);
            const income_headd = await this.connection.query(`select * from income_head LIMIT ? OFFSET ?`, [
                Number(limit), Number(offset)
            ]);
            let [totallist] = await this.connection.query(`select count(id) as total from income_head`);
            let variable = {
                details: income_headd,
                total: totallist.total,
                page: page,
                limit: limit
            };
            return variable;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupFinanceIncomeHeadService = SetupFinanceIncomeHeadService;
exports.SetupFinanceIncomeHeadService = SetupFinanceIncomeHeadService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupFinanceIncomeHeadService);
//# sourceMappingURL=setup-finance-income_head.service.js.map