"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupFinanceIncomeHeadController = void 0;
const common_1 = require("@nestjs/common");
const setup_finance_income_head_service_1 = require("./setup-finance-income_head.service");
const setup_finance_income_head_entity_1 = require("./entities/setup-finance-income_head.entity");
const auth_guard_1 = require("../auth/auth.guard");
let SetupFinanceIncomeHeadController = class SetupFinanceIncomeHeadController {
    constructor(setupFinanceIncomeHeadService) {
        this.setupFinanceIncomeHeadService = setupFinanceIncomeHeadService;
    }
    create(income_headEntity) {
        return this.setupFinanceIncomeHeadService.create(income_headEntity);
    }
    findAll() {
        return this.setupFinanceIncomeHeadService.findAll();
    }
    findOne(id) {
        return this.setupFinanceIncomeHeadService.findOne(id);
    }
    update(id, income_headEntity) {
        return this.setupFinanceIncomeHeadService.update(id, income_headEntity);
    }
    remove(id, Hospital_id) {
        return this.setupFinanceIncomeHeadService.remove(id, Hospital_id);
    }
    SetupIncomehead(search) {
        return this.setupFinanceIncomeHeadService.SetupIncomehead(search);
    }
    async findallincome_head(limit, page) {
        try {
            let final_output = await this.setupFinanceIncomeHeadService.findALLincome_head(limit || 10, page || 1);
            if (final_output.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output.details,
                    total: final_output.total,
                    limit: final_output.limit,
                    totalpages: Math.ceil(final_output.total / final_output.limit)
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE
            };
        }
    }
};
exports.SetupFinanceIncomeHeadController = SetupFinanceIncomeHeadController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [setup_finance_income_head_entity_1.SetupFinanceIncomeHead]),
    __metadata("design:returntype", void 0)
], SetupFinanceIncomeHeadController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SetupFinanceIncomeHeadController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SetupFinanceIncomeHeadController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, setup_finance_income_head_entity_1.SetupFinanceIncomeHead]),
    __metadata("design:returntype", void 0)
], SetupFinanceIncomeHeadController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", void 0)
], SetupFinanceIncomeHeadController.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/SetupIncomeHead/:search'),
    __param(0, (0, common_1.Param)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SetupFinanceIncomeHeadController.prototype, "SetupIncomehead", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/getAllincome_head'),
    __param(0, (0, common_1.Query)('limit')),
    __param(1, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], SetupFinanceIncomeHeadController.prototype, "findallincome_head", null);
exports.SetupFinanceIncomeHeadController = SetupFinanceIncomeHeadController = __decorate([
    (0, common_1.Controller)('setup-finance-income-head'),
    __metadata("design:paramtypes", [setup_finance_income_head_service_1.SetupFinanceIncomeHeadService])
], SetupFinanceIncomeHeadController);
//# sourceMappingURL=setup-finance-income_head.controller.js.map