"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupFinanceExpenseHeadController = void 0;
const common_1 = require("@nestjs/common");
const setup_finance_expense_head_service_1 = require("./setup-finance-expense_head.service");
const setup_finance_expense_head_entity_1 = require("./entities/setup-finance-expense_head.entity");
const auth_guard_1 = require("../auth/auth.guard");
let SetupFinanceExpenseHeadController = class SetupFinanceExpenseHeadController {
    constructor(setupFinanceExpenseHeadService) {
        this.setupFinanceExpenseHeadService = setupFinanceExpenseHeadService;
    }
    create(expense_headEntity) {
        return this.setupFinanceExpenseHeadService.create(expense_headEntity);
    }
    findAll() {
        return this.setupFinanceExpenseHeadService.findAll();
    }
    findOne(id) {
        return this.setupFinanceExpenseHeadService.findOne(id);
    }
    update(id, expense_headEntity) {
        return this.setupFinanceExpenseHeadService.update(id, expense_headEntity);
    }
    remove(id, Hospital_id) {
        return this.setupFinanceExpenseHeadService.remove(id, Hospital_id);
    }
    SetupExpensehead(search) {
        return this.setupFinanceExpenseHeadService.SetupExpensehead(search);
    }
    async findallexpense_head(limit, page) {
        try {
            let final_output = await this.setupFinanceExpenseHeadService.findALLexpense_head(limit || 10, page || 1);
            if (final_output.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output.details,
                    total: final_output.total,
                    limit: final_output.limit,
                    totalpages: Math.ceil(final_output.total / final_output.limit)
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE
            };
        }
    }
};
exports.SetupFinanceExpenseHeadController = SetupFinanceExpenseHeadController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [setup_finance_expense_head_entity_1.SetupFinanceExpenseHead]),
    __metadata("design:returntype", void 0)
], SetupFinanceExpenseHeadController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SetupFinanceExpenseHeadController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SetupFinanceExpenseHeadController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, setup_finance_expense_head_entity_1.SetupFinanceExpenseHead]),
    __metadata("design:returntype", void 0)
], SetupFinanceExpenseHeadController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", void 0)
], SetupFinanceExpenseHeadController.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/SetupExpenseHead/:search'),
    __param(0, (0, common_1.Param)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SetupFinanceExpenseHeadController.prototype, "SetupExpensehead", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/getAllexpense_head'),
    __param(0, (0, common_1.Query)('limit')),
    __param(1, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], SetupFinanceExpenseHeadController.prototype, "findallexpense_head", null);
exports.SetupFinanceExpenseHeadController = SetupFinanceExpenseHeadController = __decorate([
    (0, common_1.Controller)('setup-finance-expense-head'),
    __metadata("design:paramtypes", [setup_finance_expense_head_service_1.SetupFinanceExpenseHeadService])
], SetupFinanceExpenseHeadController);
//# sourceMappingURL=setup-finance-expense_head.controller.js.map