"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupBloodBankProductsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let SetupBloodBankProductsService = class SetupBloodBankProductsService {
    constructor(connection) {
        this.connection = connection;
    }
    async create(bloodproductsEntity) {
        try {
            const result = await this.connection.query('INSERT INTO blood_bank_products (name,is_blood_group) VALUES (?,?)', [bloodproductsEntity.name, bloodproductsEntity.is_blood_group]);
            return [
                {
                    'data ': {
                        'id  ': result.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.BLOOD_BANK,
                        inserted_data: await this.connection.query('SELECT * FROM blood_bank_products WHERE id = ?', [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const blood_bank_products = await this.connection.query('SELECT * FROM blood_bank_products where is_blood_group = ?', ['1']);
            return blood_bank_products;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        try {
            const blood_bank_products = await this.connection.query('SELECT * FROM blood_bank_products WHERE id = ?', [id]);
            if (blood_bank_products.length === 1) {
                return blood_bank_products;
            }
            else {
                return null;
            }
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, bloodproductsEntity) {
        try {
            await this.connection.query('UPDATE blood_bank_products SET name =? ,is_blood_group =?  WHERE id = ?', [bloodproductsEntity.name, bloodproductsEntity.is_blood_group, id]);
            return [
                {
                    'data ': {
                        status: 'success',
                        messege: 'blood_bank_products details updated successfully ',
                        updated_values: await this.connection.query('SELECT * FROM blood_bank_products WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            return [
                {
                    status: 'failed',
                    messege: 'cannot update blood_bank_products profile',
                    error: error,
                },
            ];
        }
    }
    async remove(id) {
        await this.connection.query('DELETE FROM blood_bank_products WHERE id = ?', [id]);
        return [
            {
                status: 'success',
                message: ' id: ' + id + ' deleted successfully',
            },
        ];
    }
    async SetupBloodBankProducts(search) {
        let query = ` SELECT * FROM blood_bank_products where is_blood_group = 1 `;
        let values = [];
        if (search) {
            query += ` and ( blood_bank_products.name LIKE ? )  `;
            values.push('%' + search + '%');
        }
        let final = query;
        const setupBloodBankProduct = await this.connection.query(final, values);
        return setupBloodBankProduct;
    }
};
exports.SetupBloodBankProductsService = SetupBloodBankProductsService;
exports.SetupBloodBankProductsService = SetupBloodBankProductsService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], SetupBloodBankProductsService);
//# sourceMappingURL=setup-blood_bank-products.service.js.map