"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupBedFloorService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupBedFloorService = class SetupBedFloorService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(floorEntity) {
        try {
            const result = await this.connection.query('INSERT INTO floor (name,description) VALUES (?,?)', [floorEntity.name, floorEntity.description]);
            await this.dynamicConnection.query('INSERT INTO floor(name,description,Hospital_id,hospital_floor_id) values (?,?,?,?)', [
                floorEntity.name,
                floorEntity.description,
                floorEntity.Hospital_id,
                result.insertId,
            ]);
            return [
                {
                    'data ': {
                        'id  ': result.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.BED_FLOOR,
                        inserted_data: await this.connection.query('SELECT * FROM floor WHERE id = ?', [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const floor = await this.connection.query('SELECT * FROM floor');
            return floor;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingRecord] = await this.connection.query(`SELECT * FROM floor WHERE id = ?`, [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const floor = await this.connection.query('SELECT * FROM floor WHERE id = ?', [id]);
            return floor;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, floorEntity) {
        const [existingRecord] = await this.connection.query(`SELECT id FROM floor WHERE id = ?`, [id]);
        if (!existingRecord) {
            return [
                {
                    status: process.env.ERROR,
                    message: process.env.EXISTING_RECORD
                },
            ];
        }
        try {
            await this.connection.query('UPDATE floor SET name =?, description =? WHERE id = ?', [floorEntity.name, floorEntity.description, id]);
            await this.dynamicConnection.query('update floor SET name =?, description =? where hospital_floor_id = ? and Hospital_id =?', [
                floorEntity.name,
                floorEntity.description,
                id,
                floorEntity.Hospital_id,
            ]);
            return [
                {
                    'data ': {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.BED_FLOOR_UPDATED,
                        updated_values: await this.connection.query('SELECT * FROM floor WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM floor WHERE id = ?', [id]);
        if (!existingRecord) {
            return [{ status: process.env.ERROR,
                    message: process.env.EXISTING_RECORD }];
        }
        try {
            await this.connection.query('DELETE FROM floor WHERE id = ?', [id]);
            const [bed_floor] = await this.dynamicConnection.query(`select id from floor where hospital_floor_id = ? `, [id]);
            await this.dynamicConnection.query(`delete from floor where id = ? and Hospital_id = ?`, [bed_floor.id, Hospital_id]);
            return [
                {
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DELETED
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async setupFloor(search) {
        let query = ` SELECT * FROM floor `;
        let values = [];
        if (search) {
            query += ` WHERE ( floor.name LIKE ? OR floor.description LIKE ? ) `;
            values.push('%' + search + '%');
            values.push('%' + search + '%');
        }
        let final = query;
        const setupFloorSearch = await this.connection.query(final, values);
        return setupFloorSearch;
    }
    async findAllBedFloor(limit, page) {
        const offset = limit * (page - 1);
        const Floor = await this.connection.query(`SELECT * FROM floor LIMIT ? OFFSET ? `, [Number(limit), Number(offset)]);
        try {
            let [total_list] = await this.connection.query(`SELECT count(id) as total FROM floor`);
            let out = {
                details: Floor,
                total: total_list.total,
            };
            return out;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findBedFloorSearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `SELECT * FROM floor`;
            let countQuery = `SELECT COUNT(floor.id) AS total FROM floor`;
            if (search) {
                const condition = ` WHERE floor.name LIKE ? OR floor.description LIKE ? `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern, pattern);
            }
            baseQuery += ` ORDER BY floor.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const BedFloorSearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: BedFloorSearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupBedFloorService = SetupBedFloorService;
exports.SetupBedFloorService = SetupBedFloorService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupBedFloorService);
//# sourceMappingURL=setup-bed-floor.service.js.map