"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupBedBedTypeService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupBedBedTypeService = class SetupBedBedTypeService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(bed_typeEntity) {
        try {
            const result = await this.connection.query('INSERT INTO bed_type (name) VALUES (?)', [bed_typeEntity.name]);
            await this.dynamicConnection.query('INSERt INTO bed_type (name,Hospital_id,hospital_bed_type_id) values (?,?,?)', [bed_typeEntity.name, bed_typeEntity.Hospital_id, result.insertId]);
            return [
                {
                    'data ': {
                        'id  ': result.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.BED_TYPE,
                        inserted_data: await this.connection.query('SELECT * FROM bed_type WHERE id = ?', [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const bed_type = await this.connection.query('SELECT * FROM bed_type');
            return bed_type;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingRecord] = await this.connection.query('SELECT * FROM bed_type WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const bed_type = await this.connection.query('SELECT * FROM bed_type WHERE id = ?', [id]);
            return bed_type;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, bed_typeEntity) {
        const [existingRecord] = await this.connection.query('SELECT id FROM bed_type WHERE id = ?', [id]);
        if (!existingRecord) {
            return [
                {
                    status: process.env.ERROR,
                    message: process.env.EXISTING_RECORD
                },
            ];
        }
        try {
            await this.connection.query('UPDATE bed_type SET name =? WHERE id = ?', [
                bed_typeEntity.name,
                id,
            ]);
            await this.dynamicConnection.query('update bed_type SET name =? where hospital_bed_type_id = ? and Hospital_id= ?', [bed_typeEntity.name, id, bed_typeEntity.Hospital_id]);
            return [
                {
                    'data ': {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.BED_TYPE_UPDATED,
                        updated_values: await this.connection.query('SELECT * FROM bed_type WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM bed_type WHERE id = ?', [id]);
        if (!existingRecord) {
            return [
                {
                    status: process.env.ERROR,
                    message: process.env.EXISTING_RECORD
                },
            ];
        }
        try {
            await this.connection.query('DELETE FROM bed_type WHERE id = ?', [id]);
            const [admin] = await this.dynamicConnection.query(`select id from bed_type where hospital_bed_type_id = ?`, [id]);
            await this.dynamicConnection.query(`delete from bed_type where id = ? and Hospital_id = ?`, [admin.id, Hospital_id]);
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return [
            {
                status: process.env.SUCCESS_STATUS_V2,
                message: process.env.DELETED
            },
        ];
    }
    async setupBedType(search) {
        let query = ` SELECT * FROM bed_type `;
        let values = [];
        if (search) {
            query += ` WHERE ( bed_type.name LIKE ? ) `;
            values.push('%' + search + '%');
        }
        let final = query;
        const setupBedTypeSearch = await this.connection.query(final, values);
        return setupBedTypeSearch;
    }
    async findAllBedType(limit, page) {
        const offset = limit * (page - 1);
        const Bed_type = await this.connection.query(`SELECT * FROM bed_type LIMIT ? OFFSET ? `, [Number(limit), Number(offset)]);
        try {
            let [total_list] = await this.connection.query(`SELECT count(id) as total FROM bed_type`);
            let out = {
                details: Bed_type,
                total: total_list.total,
            };
            return out;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findBedTypeSearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `SELECT * FROM bed_type`;
            let countQuery = `SELECT COUNT(bed_type.id) AS total FROM bed_type`;
            if (search) {
                const condition = ` WHERE bed_type.name LIKE ? `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern);
            }
            baseQuery += ` ORDER BY bed_type.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const BedTypeSearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: BedTypeSearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupBedBedTypeService = SetupBedBedTypeService;
exports.SetupBedBedTypeService = SetupBedBedTypeService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupBedBedTypeService);
//# sourceMappingURL=setup-bed-bed_type.service.js.map