"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupBedBedStatusService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let SetupBedBedStatusService = class SetupBedBedStatusService {
    constructor(connection) {
        this.connection = connection;
    }
    async findAll() {
        try {
            const bed_status = await this.connection
                .query(`select bed.id, bed.name,bed.is_active as status,bed_type.name AS bed_type,bed_group.name AS bed_group,
    floor.name As floor from bed join bed_type ON bed.bed_type_id = bed_type.id join bed_group ON bed.bed_group_id = bed_group.id  
    left join floor on bed_group.floor = floor.id;`);
            return bed_status;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingRecord] = await this.connection.query(`
        SELECT id FROM bed where id = ?`, [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const bed_status = await this.connection.query(`select bed.id, bed.name,bed.is_active as status,bed_type.name AS bed_type,bed_group.name AS bed_group,
      floor.name As floor from bed join bed_type ON bed.bed_type_id = bed_type.id join bed_group ON bed.bed_group_id = bed_group.id  
      left join floor on bed_group.floor = floor.id WHERE bed.id = ?`, [id]);
            return bed_status;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async setupBedStatus(search) {
        let query = ` select bed.id, bed.name,bed.is_active as status,bed_type.name AS bed_type,bed_group.name AS bed_group,
    floor.name As floor from bed join bed_type ON bed.bed_type_id = bed_type.id join bed_group ON bed.bed_group_id = bed_group.id  
    left join floor on bed_group.floor = floor.id `;
        let values = [];
        if (search) {
            query += ` WHERE ( bed.name LIKE ? OR bed_type.name LIKE ? OR bed_group.name LIKE ? OR floor.name LIKE ? OR bed.is_active LIKE ? ) `;
            values.push('%' + search + '%');
            values.push('%' + search + '%');
            values.push('%' + search + '%');
            values.push('%' + search + '%');
            values.push('%' + search + '%');
        }
        let final = query;
        const setupBedStatusSearch = await this.connection.query(final, values);
        return setupBedStatusSearch;
    }
    async findAllBedStatus(limit, page) {
        const offset = limit * (page - 1);
        const BedStatus = await this.connection.query(`select bed.id, bed.name,bed.is_active as status,bed_type.name AS bed_type,bed_group.name AS bed_group,
    floor.name As floor from bed join bed_type ON bed.bed_type_id = bed_type.id join bed_group ON bed.bed_group_id = bed_group.id  
    left join floor on bed_group.floor = floor.id LIMIT ? OFFSET ? `, [Number(limit), Number(offset)]);
        try {
            let [total_list] = await this.connection.query(`SELECT count(id) as total FROM bed`);
            let out = {
                details: BedStatus,
                total: total_list.total,
            };
            return out;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findBedStatusSearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
        select bed.id, bed.name,bed.is_active as status,bed_type.name AS bed_type,bed_group.name AS bed_group,
    floor.name As floor from bed join bed_type ON bed.bed_type_id = bed_type.id join bed_group ON bed.bed_group_id = bed_group.id  
    left join floor on bed_group.floor = floor.id
      `;
            let countQuery = `
        SELECT COUNT(bed.id) AS total 
        FROM bed 
        join bed_type ON bed.bed_type_id = bed_type.id 
        join bed_group ON bed.bed_group_id = bed_group.id  
        left join floor on bed_group.floor = floor.id
      `;
            if (search) {
                const condition = `
          WHERE bed.name LIKE ? OR bed_type.name LIKE ? OR bed_group.name LIKE ? OR floor.name LIKE ? OR bed.is_active LIKE ? `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern, pattern, pattern, pattern, pattern);
            }
            baseQuery += ` ORDER BY bed.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const BedStatusSearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: BedStatusSearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupBedBedStatusService = SetupBedBedStatusService;
exports.SetupBedBedStatusService = SetupBedBedStatusService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], SetupBedBedStatusService);
//# sourceMappingURL=setup-bed-bed_status.service.js.map