"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupBedBedGroupService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupBedBedGroupService = class SetupBedBedGroupService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(bed_groupEntity) {
        try {
            const [bed] = await this.connection.query(`select id from floor where id = ?`, [bed_groupEntity.floor]);
            if (!bed) {
                return [
                    {
                        status: process.env.ERROR,
                        message: `${process.env.FLOOR_ID} ${bed_groupEntity.floor} ${process.env.NOT_EXIST}`,
                    },
                ];
            }
            const result = await this.connection.query('INSERT INTO bed_group (name,color,description,floor,is_active) VALUES (?,?,?,?,?)', [
                bed_groupEntity.name,
                bed_groupEntity.color,
                bed_groupEntity.description,
                bed.id,
                bed_groupEntity.is_active,
            ]);
            const [admin_bed] = await this.dynamicConnection.query(`select id from floor where hospital_floor_id = ? and Hospital_id = ?`, [bed_groupEntity.floor, bed_groupEntity.Hospital_id]);
            await this.dynamicConnection.query('INSERT INTO bed_group (name,color,description,floor,is_active,Hospital_id,hospital_bed_group_id) VALUES (?,?,?,?,?,?,?)', [
                bed_groupEntity.name,
                bed_groupEntity.color,
                bed_groupEntity.description,
                admin_bed.id,
                bed_groupEntity.is_active,
                bed_groupEntity.Hospital_id,
                result.insertId,
            ]);
            return [
                {
                    'data ': {
                        'id  ': result.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.BED_GROUP,
                        inserted_data: await this.connection.query('SELECT * FROM bed_group WHERE id = ?', [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const bed_group = await this.connection.query('SELECT bed_group.id, bed_group.name, floor.name AS floor_name, bed_group.description, bed_group.color, bed_group.is_active  FROM bed_group  JOIN floor ON bed_group.floor = floor.id');
            return bed_group;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingRecord] = await this.dynamicConnection.query('SELECT * FROM bed_group WHERE hospital_bed_group_id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const bed_group = await this.connection.query(`SELECT bed_group.id, bed_group.name, floor.name AS floor_name, 
        bed_group.description, bed_group.color, bed_group.is_active 
         FROM bed_group  JOIN floor ON bed_group.floor = floor.id 
         WHERE bed_group.id = ?`, [id]);
            return bed_group;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, bed_groupEntity) {
        const [existingRecord] = await this.connection.query('SELECT id FROM bed_group WHERE id = ?', [id]);
        if (!existingRecord) {
            return [
                {
                    status: process.env.ERROR,
                    message: process.env.EXISTING_RECORD,
                },
            ];
        }
        const [bed] = await this.connection.query(`select id from floor where id = ?`, [bed_groupEntity.floor]);
        if (!bed) {
            return [
                {
                    status: process.env.ERROR,
                    message: `${process.env.FLOOR_ID} ${bed_groupEntity.floor} ${process.env.NOT_EXIST}`,
                },
            ];
        }
        try {
            await this.connection.query('UPDATE bed_group SET name =? , color =? , description =? , floor =? WHERE id = ?', [
                bed_groupEntity.name,
                bed_groupEntity.color,
                bed_groupEntity.description,
                bed.id,
                id,
            ]);
            const [admin_bed] = await this.dynamicConnection.query(`select id from floor where hospital_floor_id = ? and Hospital_id = ?`, [bed_groupEntity.floor, bed_groupEntity.Hospital_id]);
            await this.dynamicConnection.query('update bed_group SET  name =? , color =? , description =? , floor =? where hospital_bed_group_id = ? and Hospital_id = ?', [
                bed_groupEntity.name,
                bed_groupEntity.color,
                bed_groupEntity.description,
                admin_bed.id,
                id,
                bed_groupEntity.Hospital_id,
            ]);
            return [
                {
                    'data ': {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.BED_GROUP_UPDATED,
                        updated_values: await this.connection.query('SELECT * FROM bed_group WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        const [existingRecord] = await this.connection.query(`SELECT id FROM bed_group WHERE id = ?`, [id]);
        if (!existingRecord) {
            return [
                {
                    status: process.env.ERROR,
                    message: process.env.EXISTING_RECORD
                },
            ];
        }
        try {
            await this.connection.query('DELETE FROM bed_group WHERE id = ?', [id]);
            const [bed_group] = await this.dynamicConnection.query(`select id from bed_group where hospital_bed_group_id = ?`, [id]);
            await this.dynamicConnection.query(`delete from bed_group where id = ? and Hospital_id = ?`, [bed_group.id, Hospital_id]);
            return [
                {
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DELETED
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async setupBedGroup(search) {
        let query = ` SELECT bed_group.id, bed_group.name, floor.name AS floor_name, bed_group.description, bed_group.color, bed_group.is_active  FROM bed_group  JOIN floor ON bed_group.floor = floor.id `;
        let values = [];
        if (search) {
            query += ` WHERE ( bed_group.name LIKE ? OR floor.name LIKE ? OR bed_group.description LIKE ? ) `;
            values.push('%' + search + '%');
            values.push('%' + search + '%');
            values.push('%' + search + '%');
        }
        let final = query;
        const setupBedGroupSearch = await this.connection.query(final, values);
        return setupBedGroupSearch;
    }
    async findAllBedGroup(limit, page) {
        const offset = limit * (page - 1);
        const Bed_group = await this.connection.query(`SELECT bed_group.id, bed_group.name, floor.name AS floor_name, 
            bed_group.description, bed_group.color, bed_group.is_active  FROM bed_group 
             JOIN floor ON bed_group.floor = floor.id LIMIT ? OFFSET ? `, [Number(limit), Number(offset)]);
        try {
            let [total_list] = await this.connection.query(`SELECT count(id) as total FROM bed_group`);
            let out = {
                details: Bed_group,
                total: total_list.total,
            };
            return out;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findBedgroupSearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
        SELECT bed_group.id, bed_group.name, floor.name AS floor_name, 
               bed_group.description, bed_group.color, bed_group.is_active  
        FROM bed_group  
        JOIN floor ON bed_group.floor = floor.id
      `;
            let countQuery = `
        SELECT COUNT(bed_group.id) AS total 
        FROM bed_group 
        JOIN floor ON bed_group.floor = floor.id
      `;
            if (search) {
                const condition = `
          WHERE bed_group.name LIKE ? 
          OR floor.name LIKE ? 
          OR bed_group.description LIKE ? `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern, pattern, pattern);
            }
            baseQuery += ` ORDER BY bed_group.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const BedGroupSearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: BedGroupSearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupBedBedGroupService = SetupBedBedGroupService;
exports.SetupBedBedGroupService = SetupBedBedGroupService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupBedBedGroupService);
//# sourceMappingURL=setup-bed-bed_group.service.js.map