"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupBedBedService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupBedBedService = class SetupBedBedService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(bedEntity) {
        try {
            const result = await this.connection.query('INSERT INTO bed (name,bed_type_id,bed_group_id,is_active) VALUES (?,?,?,?)', [
                bedEntity.name,
                bedEntity.bed_type_id,
                bedEntity.bed_group_id,
                bedEntity.is_active,
            ]);
            const [bed_type] = await this.dynamicConnection.query(`select id from bed_type where Hospital_id = ? and hospital_bed_type_id = ?`, [bedEntity.Hospital_id, bedEntity.bed_type_id]);
            const [bed_group] = await this.dynamicConnection.query(`select id from bed_group where Hospital_id =? and hospital_bed_group_id = ?`, [bedEntity.Hospital_id, bedEntity.bed_group_id]);
            await this.dynamicConnection.query('INSERT INTO bed (name,bed_type_id,bed_group_id,is_active,Hospital_id,hospital_bed_id) values (?,?,?,?,?,?) ', [
                bedEntity.name,
                bed_type.id,
                bed_group.id,
                bedEntity.is_active,
                bedEntity.Hospital_id,
                result.insertId,
            ]);
            return [
                {
                    'data ': {
                        'id  ': result.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.BED,
                        inserted_data: await this.connection.query('SELECT * FROM bed WHERE id = ?', [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const bed = await this.connection.query("SELECT bed.id,bed.name, bed.is_active as used,bed.bed_type_id, bed_type.name as Bed_Type,bed.bed_group_id, CONCAT(bed_group.name, '-', floor.name) AS bed_group FROM bed left JOIN bed_type ON bed.bed_type_id = bed_type.id left JOIN bed_group ON bed.bed_group_id = bed_group.id left JOIN floor ON bed_group.floor = floor.id");
            return bed;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        try {
            const bed = await this.connection.query("SELECT bed.id, bed.name, bed.is_active as used, bed_type.name as Bed_Type, CONCAT(bed_group.name, '-', floor.name) AS bed_group FROM bed left JOIN bed_type ON bed.bed_type_id = bed_type.id left JOIN bed_group ON bed.bed_group_id = bed_group.id left JOIN floor ON bed_group.floor = floor.id WHERE bed.id = ?", [id]);
            if (bed.length === 1) {
                return bed;
            }
            else {
                return null;
            }
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, bedEntity) {
        try {
            await this.connection.query('UPDATE bed SET name =?, bed_type_id =?, bed_group_id =?, is_active =? WHERE id = ?', [
                bedEntity.name,
                bedEntity.bed_type_id,
                bedEntity.bed_group_id,
                bedEntity.is_active,
                id,
            ]);
            const [bed_type_id] = await this.dynamicConnection.query(`select id from bed_type where hospital_bed_type_id = ? and Hospital_id = ?`, [bedEntity.bed_type_id, bedEntity.Hospital_id]);
            const [bed_group_id] = await this.dynamicConnection.query(`select id from bed_group where hospital_bed_group_id = ? and Hospital_id = ?`, [bedEntity.bed_group_id, bedEntity.Hospital_id]);
            await this.dynamicConnection.query('update bed SET  name =?, bed_type_id =?, bed_group_id =?, is_active =? where hospital_bed_id = ? and Hospital_id = ?', [
                bedEntity.name,
                bed_type_id.id,
                bed_group_id.id,
                bedEntity.is_active,
                id,
                bedEntity.Hospital_id,
            ]);
            return [
                {
                    'data ': {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.BED_UPDATED,
                        updated_values: await this.connection.query('SELECT * FROM bed WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        try {
            await this.connection.query('DELETE FROM bed WHERE id = ?', [id]);
            const [bed] = await this.dynamicConnection.query(`select id from bed where hospital_bed_id = ?`, [id]);
            await this.dynamicConnection.query(`delete from bed where id = ? and Hospital_id = ? `, [bed.id, Hospital_id]);
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return [
            {
                status: process.env.SUCCESS_STATUS_V2,
                message: process.env.DELETED
            },
        ];
    }
    async setupBed(search) {
        let query = ` SELECT bed.id,bed.name, bed.is_active as used,bed.bed_type_id, bed_type.name as Bed_Type,bed.bed_group_id, CONCAT(bed_group.name, '-', floor.name) AS bed_group FROM bed JOIN bed_type ON bed.bed_type_id = bed_type.id JOIN bed_group ON bed.bed_group_id = bed_group.id JOIN floor ON bed_group.floor = floor.id `;
        let values = [];
        if (search) {
            query += ` WHERE ( bed.name LIKE ? OR bed_type.name LIKE ? OR CONCAT(bed_group.name, '-', floor.name) LIKE ? ) `;
            values.push('%' + search + '%');
            values.push('%' + search + '%');
            values.push('%' + search + '%');
        }
        let final = query;
        const setupBedSearch = await this.connection.query(final, values);
        return setupBedSearch;
    }
    async findAllBed(limit, page) {
        const offset = limit * (page - 1);
        const Bed = await this.connection.query(`SELECT bed.id,bed.name, bed.is_active as used,bed.bed_type_id, bed_type.name as Bed_Type,bed.bed_group_id, CONCAT(bed_group.name, '-', floor.name) AS bed_group FROM bed left JOIN bed_type ON bed.bed_type_id = bed_type.id left JOIN bed_group ON bed.bed_group_id = bed_group.id left JOIN floor ON bed_group.floor = floor.id LIMIT ? OFFSET ? `, [Number(limit), Number(offset)]);
        try {
            let [total_list] = await this.connection.query(`SELECT count(id) as total FROM bed`);
            let out = {
                details: Bed,
                total: total_list.total,
            };
            return out;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findBedSearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
        SELECT bed.id,bed.name, bed.is_active as used,bed.bed_type_id, bed_type.name as Bed_Type,bed.bed_group_id, CONCAT(bed_group.name, '-', floor.name) AS bed_group FROM bed left JOIN bed_type ON bed.bed_type_id = bed_type.id left JOIN bed_group ON bed.bed_group_id = bed_group.id left JOIN floor ON bed_group.floor = floor.id
      `;
            let countQuery = `
        SELECT COUNT(bed.id) AS total 
        FROM bed 
        left JOIN bed_type ON bed.bed_type_id = bed_type.id 
        left JOIN bed_group ON bed.bed_group_id = bed_group.id 
        left JOIN floor ON bed_group.floor = floor.id
      `;
            if (search) {
                const condition = `
          WHERE bed.name LIKE ? OR bed_type.name LIKE ? OR CONCAT(bed_group.name, '-', floor.name) LIKE ? `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern, pattern, pattern);
            }
            baseQuery += ` ORDER BY bed.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const BedSearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: BedSearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupBedBedService = SetupBedBedService;
exports.SetupBedBedService = SetupBedBedService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupBedBedService);
//# sourceMappingURL=setup-bed-bed.service.js.map