"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupAppointmentShiftService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupAppointmentShiftService = class SetupAppointmentShiftService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(appointment_shiftEntity) {
        try {
            const overlappingShift = await this.connection.query(`SELECT * FROM global_shift WHERE 
          (start_time < ? AND end_time > ?)`, [
                appointment_shiftEntity.end_time,
                appointment_shiftEntity.start_time,
            ]);
            if (overlappingShift.length > 0) {
                return [
                    {
                        status: process.env.ERROR,
                        message: process.env.SHIFT_OVERLAP,
                    },
                ];
            }
            const result = await this.connection.query('INSERT INTO global_shift (name, start_time, end_time) VALUES (?, ?, ?)', [
                appointment_shiftEntity.name,
                appointment_shiftEntity.start_time,
                appointment_shiftEntity.end_time,
            ]);
            await this.dynamicConnection.query(`INSERT INTO global_shift (name, start_time, end_time, Hospital_id, hospital_global_shift_id) VALUES (?, ?, ?, ?, ?)`, [
                appointment_shiftEntity.name,
                appointment_shiftEntity.start_time,
                appointment_shiftEntity.end_time,
                appointment_shiftEntity.Hospital_id,
                result.insertId,
            ]);
            return [
                {
                    data: {
                        id: result.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        message: process.env.SHIFT_ADDED,
                        inserted_data: await this.connection.query('SELECT * FROM global_shift WHERE id = ?', [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statuscode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const global_shift = await this.connection.query('SELECT * FROM global_shift');
            return global_shift;
        }
        catch (error) {
            throw new common_1.HttpException({
                statuscode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM global_shift WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const global_shift = await this.connection.query('SELECT * FROM global_shift WHERE id = ?', [id]);
            return global_shift;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, appointment_shiftEntity) {
        try {
            const [existingRecord] = await this.connection.query('SELECT id FROM global_shift WHERE id = ?', [id]);
            if (!existingRecord) {
                return [{ status: process.env.ERROR,
                        message: process.env.EXISTING_RECORD }];
            }
            if (appointment_shiftEntity.start_time >= appointment_shiftEntity.end_time) {
                return [{
                        status: process.env.ERROR_STATUS,
                        message: process.env.SHIFT_TIME,
                    }];
            }
            const overlappingShift = await this.connection.query(`SELECT * FROM global_shift WHERE 
    (start_time < ? AND end_time > ? AND id != ?)`, [
                appointment_shiftEntity.end_time,
                appointment_shiftEntity.start_time,
                id
            ]);
            if (overlappingShift.length > 0) {
                return [
                    {
                        status: process.env.ERROR,
                        message: process.env.SHIFT_OVERLAPPING,
                    },
                ];
            }
            await this.connection.query('UPDATE global_shift SET name =? ,start_time =?, end_time =? WHERE id = ?', [
                appointment_shiftEntity.name,
                appointment_shiftEntity.start_time,
                appointment_shiftEntity.end_time,
                id,
            ]);
            await this.dynamicConnection.query('update global_shift SET name =? ,start_time =?, end_time =? where hospital_global_shift_id =? and Hospital_id = ?', [
                appointment_shiftEntity.name,
                appointment_shiftEntity.start_time,
                appointment_shiftEntity.end_time,
                id,
                appointment_shiftEntity.Hospital_id,
            ]);
            return [
                {
                    'data ': {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.SHIFT_UPDATED,
                        updated_values: await this.connection.query('SELECT * FROM global_shift WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM global_shift WHERE id = ?', [id]);
        if (!existingRecord) {
            return [{ status: process.env.ERROR,
                    message: process.env.EXISTING_RECORD }];
        }
        await this.connection.query('DELETE FROM global_shift WHERE id = ?', [id]);
        try {
            const resul = await this.dynamicConnection.query('select id from global_shift where hospital_global_shift_id = ?', [id]);
            const shift = resul[0].id;
            await this.dynamicConnection.query(`delete from global_shift where id = ? and Hospital_id = ?`, [shift, Hospital_id]);
            return [
                {
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DELETED
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async AppointmentShift(search) {
        let query = ` SELECT * FROM global_shift `;
        let values = [];
        if (search) {
            query += ` WHERE ( global_shift.name LIKE ? OR global_shift.start_time LIKE ? OR global_shift.end_time LIKE ? )  `;
            values.push('%' + search + '%');
            values.push('%' + search + '%');
            values.push('%' + search + '%');
        }
        let final = query;
        const appointmentShiftSearch = await this.connection.query(final, values);
        return appointmentShiftSearch;
    }
    async findallshift(limit, page, search) {
        try {
            const offset = limit * (page - 1);
            const searchfilter = search ? `AND (name LIKE ? OR start_time LIKE ? OR end_time LIKE ?)` : '';
            const queryParams = search
                ? [`%${search}%`, `%${search}%`, `%${search}%`, Number(limit), Number(offset)]
                : [Number(limit), Number(offset)];
            console.log("queryParams", queryParams);
            const global_shift = await this.connection.query(`SELECT * FROM global_shift WHERE 1=1 ${searchfilter} LIMIT ? OFFSET ?`, queryParams);
            console.log("global_shift", global_shift);
            const countParams = search
                ? [`%${search}%`, `%${search}%`, `%${search}%`]
                : [];
            console.log("countParams", countParams);
            let [totallist] = await this.connection.query(`SELECT count(id) as total FROM global_shift WHERE 1=1 ${searchfilter}`, countParams);
            console.log("totallist", totallist);
            let variable = {
                details: global_shift,
                total: totallist.total
            };
            return variable;
        }
        catch (error) {
            throw new common_1.HttpException({
                statuscode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupAppointmentShiftService = SetupAppointmentShiftService;
exports.SetupAppointmentShiftService = SetupAppointmentShiftService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupAppointmentShiftService);
//# sourceMappingURL=setup-appointment-shift.service.js.map