"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupAppointmentDoctorShiftService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupAppointmentDoctorShiftService = class SetupAppointmentDoctorShiftService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(doctor_shiftEntity) {
        try {
            const [Hos_staff_email] = await this.connection.query(`select email from staff where id = ?`, [doctor_shiftEntity.staff_id]);
            const [Admin_staff_id] = await this.dynamicConnection.query(`select id from staff where email = ?`, [Hos_staff_email.email]);
            const [Admin_global_shift_id] = await this.dynamicConnection.query(`select id from global_shift where Hospital_id = ? and hospital_global_shift_id = ?`, [doctor_shiftEntity.Hospital_id, doctor_shiftEntity.global_shift_id]);
            const [check] = await this.connection.query(`select id from doctor_global_shift where staff_id = ? and global_shift_id = ?`, [doctor_shiftEntity.staff_id, doctor_shiftEntity.global_shift_id]);
            try {
                if (check) {
                    await this.connection.query(`delete from doctor_global_shift where id = ?`, [check.id]);
                    await this.dynamicConnection.query(`delete from doctor_global_shift where Hospital_id = ? and hospital_doctor_global_shift_id = ?`, [doctor_shiftEntity.Hospital_id, check.id]);
                    return [
                        {
                            'data ': {
                                status: process.env.SUCCESS_STATUS_V2,
                                messege: process.env.DELETED,
                            },
                        },
                    ];
                }
                else {
                    const newHos = await this.connection.query(`insert into doctor_global_shift (staff_id,global_shift_id) values (?,?)`, [doctor_shiftEntity.staff_id, doctor_shiftEntity.global_shift_id]);
                    await this.dynamicConnection.query(`insert into doctor_global_shift (staff_id,global_shift_id,Hospital_id,hospital_doctor_global_shift_id)
      values (?,?,?,?)`, [
                        Admin_staff_id.id,
                        Admin_global_shift_id.id,
                        doctor_shiftEntity.Hospital_id,
                        newHos.insertId,
                    ]);
                    return [
                        {
                            'data ': {
                                status: process.env.SUCCESS_STATUS_V2,
                                messege: process.env.DOCTOR_GLOBAL_SHIFT,
                            },
                        },
                    ];
                }
            }
            catch (error) { }
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const doctor_shift = await this.connection.query(`
        SELECT
              staff.id,
              concat(staff.name," ",staff.surname,"(",staff.employee_id,")") AS doctor_name,
              JSON_ARRAYAGG(
                  JSON_OBJECT('shift', global_shift.name,'id',global_shift.id)
              ) AS global_shifts
          FROM
              staff
          LEFT JOIN
              doctor_global_shift ON doctor_global_shift.staff_id = staff.id
          LEFT JOIN
              global_shift ON global_shift.id = doctor_global_shift.global_shift_id
              left join
              staff_roles ON staff.id = staff_roles.staff_id
              where staff_roles.role_id = 3
             
          GROUP BY
              staff.id,
              CONCAT(staff.name, ' ', staff.surname, '(', staff.employee_id, ')');
      `);
            return doctor_shift;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async AppointmentDoctorShift(search) {
        try {
            let query = ` SELECT
  staff.id,
  concat(staff.name," ",staff.surname,"(",staff.employee_id,")") AS doctor_name,
  JSON_ARRAYAGG(
      JSON_OBJECT('shift', global_shift.name,'id',global_shift.id)
  ) AS global_shifts
FROM
  staff
LEFT JOIN
  doctor_global_shift ON doctor_global_shift.staff_id = staff.id
LEFT JOIN
  global_shift ON global_shift.id = doctor_global_shift.global_shift_id
  left join
  staff_roles ON staff.id = staff_roles.staff_id
  where staff_roles.role_id = 3
`;
            let values = [];
            if (search) {
                query += ` AND (concat(staff.name," ",staff.surname,"(",staff.employee_id,")") LIKE ?) `;
                values.push('%' + search + '%');
            }
            let last = ` GROUP BY
  staff.id,
  CONCAT(staff.name, ' ', staff.surname, '(', staff.employee_id, ')') `;
            let final = query + last;
            const appointmentDoctorShiftSearch = await this.connection.query(final, values);
            return appointmentDoctorShiftSearch;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findalldoctorshift(limit, page, search) {
        try {
            const offset = limit * (page - 1);
            const searchfilter = search ? `AND (staff.name LIKE ? OR staff.surname LIKE ? OR staff.employee_id LIKE ?)` : '';
            const queryParams = search
                ? [`%${search}%`, `%${search}%`, `%${search}%`, Number(limit), Number(offset)]
                : [Number(limit), Number(offset)];
            const doctor_shift = await this.connection.query(`
      SELECT
        staff.id,
        CONCAT(staff.name, " ", staff.surname, "(", staff.employee_id, ")") AS doctor_name,
        JSON_ARRAYAGG(
          JSON_OBJECT('shift', global_shift.name, 'id', global_shift.id)
        ) AS global_shifts
      FROM staff
      LEFT JOIN doctor_global_shift ON doctor_global_shift.staff_id = staff.id
      LEFT JOIN global_shift ON global_shift.id = doctor_global_shift.global_shift_id
      LEFT JOIN staff_roles ON staff.id = staff_roles.staff_id
      WHERE staff_roles.role_id = 3
      ${searchfilter}
      GROUP BY staff.id, CONCAT(staff.name, ' ', staff.surname, '(', staff.employee_id, ')')
      LIMIT ? OFFSET ?
    `, queryParams);
            const countParams = search
                ? [`%${search}%`, `%${search}%`, `%${search}%`]
                : [];
            const [total_list] = await this.connection.query(`
      SELECT COUNT(DISTINCT staff.id) AS total
      FROM staff
      LEFT JOIN doctor_global_shift ON doctor_global_shift.staff_id = staff.id
      LEFT JOIN global_shift ON global_shift.id = doctor_global_shift.global_shift_id
      LEFT JOIN staff_roles ON staff.id = staff_roles.staff_id
      WHERE staff_roles.role_id = 3 
      ${searchfilter}
    `, countParams);
            let doctor_shift_variable = {
                details: doctor_shift,
                total: total_list.total
            };
            return doctor_shift_variable;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupAppointmentDoctorShiftService = SetupAppointmentDoctorShiftService;
exports.SetupAppointmentDoctorShiftService = SetupAppointmentDoctorShiftService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupAppointmentDoctorShiftService);
//# sourceMappingURL=setup-appointment-doctor_shift.service.js.map