"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupAppointmentDoctorShiftController = void 0;
const common_1 = require("@nestjs/common");
const setup_appointment_doctor_shift_service_1 = require("./setup-appointment-doctor_shift.service");
const setup_appointment_doctor_shift_entity_1 = require("./entities/setup-appointment-doctor_shift.entity");
const auth_guard_1 = require("../auth/auth.guard");
let SetupAppointmentDoctorShiftController = class SetupAppointmentDoctorShiftController {
    constructor(setupAppointmentDoctorShiftService) {
        this.setupAppointmentDoctorShiftService = setupAppointmentDoctorShiftService;
    }
    create(doctor_shiftEntity) {
        return this.setupAppointmentDoctorShiftService.create(doctor_shiftEntity);
    }
    findAll() {
        return this.setupAppointmentDoctorShiftService.findAll();
    }
    AppointmentDoctorShift(search) {
        return this.setupAppointmentDoctorShiftService.AppointmentDoctorShift(search);
    }
    async findAllDesig(limit, page, search) {
        try {
            const final_output = await this.setupAppointmentDoctorShiftService.findalldoctorshift(limit || 10, page || 1, search || '');
            if (final_output.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output.details,
                    total: final_output.total
                };
            }
            return this.setupAppointmentDoctorShiftService.findalldoctorshift(limit, page, search);
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE
            };
        }
    }
};
exports.SetupAppointmentDoctorShiftController = SetupAppointmentDoctorShiftController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [setup_appointment_doctor_shift_entity_1.SetupAppointmentDoctorShift]),
    __metadata("design:returntype", void 0)
], SetupAppointmentDoctorShiftController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SetupAppointmentDoctorShiftController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/keyword/appointmentDoctorShift/:search'),
    __param(0, (0, common_1.Param)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SetupAppointmentDoctorShiftController.prototype, "AppointmentDoctorShift", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/getAllpage'),
    __param(0, (0, common_1.Query)('limit')),
    __param(1, (0, common_1.Query)('page')),
    __param(2, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String]),
    __metadata("design:returntype", Promise)
], SetupAppointmentDoctorShiftController.prototype, "findAllDesig", null);
exports.SetupAppointmentDoctorShiftController = SetupAppointmentDoctorShiftController = __decorate([
    (0, common_1.Controller)('setup-appointment-doctor-shift'),
    __metadata("design:paramtypes", [setup_appointment_doctor_shift_service_1.SetupAppointmentDoctorShiftService])
], SetupAppointmentDoctorShiftController);
//# sourceMappingURL=setup-appointment-doctor_shift.controller.js.map