"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SettingsPaymentMethodsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SettingsPaymentMethodsService = class SettingsPaymentMethodsService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(SettingsPaymentMethodEntity) {
        try {
            const [check] = await this.connection.query(`select id from payment_settings where payment_type = ?`, [SettingsPaymentMethodEntity.payment_type]);
            if (check) {
                await this.connection.query(`update payment_settings SET payment_type = ?, api_username = ?, api_secret_key = ?, salt = ?, api_publishable_key = ?, paytm_website = ?,
    paytm_industrytype = ?, api_password = ?, api_signature = ?, api_email = ?, paypal_demo = ?, account_no = ?, is_active = ? where id = ?`, [
                    SettingsPaymentMethodEntity.payment_type,
                    SettingsPaymentMethodEntity.api_username,
                    SettingsPaymentMethodEntity.api_secret_key,
                    SettingsPaymentMethodEntity.salt,
                    SettingsPaymentMethodEntity.api_publishable_key,
                    SettingsPaymentMethodEntity.paytm_website,
                    SettingsPaymentMethodEntity.paytm_industrytype,
                    SettingsPaymentMethodEntity.api_password,
                    SettingsPaymentMethodEntity.api_signature,
                    SettingsPaymentMethodEntity.api_email,
                    SettingsPaymentMethodEntity.paypal_demo,
                    SettingsPaymentMethodEntity.account_no,
                    SettingsPaymentMethodEntity.is_active,
                    check.id
                ]);
                await this.dynamicConnection.query(`update payment_settings SET payment_type = ?, api_username = ?, api_secret_key = ?, salt = ?, api_publishable_key = ?, paytm_website = ?,
    paytm_industrytype = ?, api_password = ?, api_signature = ?, api_email = ?, paypal_demo = ?, account_no = ?, is_active = ? where hos_payment_settings_id = ?`, [
                    SettingsPaymentMethodEntity.payment_type,
                    SettingsPaymentMethodEntity.api_username,
                    SettingsPaymentMethodEntity.api_secret_key,
                    SettingsPaymentMethodEntity.salt,
                    SettingsPaymentMethodEntity.api_publishable_key,
                    SettingsPaymentMethodEntity.paytm_website,
                    SettingsPaymentMethodEntity.paytm_industrytype,
                    SettingsPaymentMethodEntity.api_password,
                    SettingsPaymentMethodEntity.api_signature,
                    SettingsPaymentMethodEntity.api_email,
                    SettingsPaymentMethodEntity.paypal_demo,
                    SettingsPaymentMethodEntity.account_no,
                    SettingsPaymentMethodEntity.is_active,
                    check.id
                ]);
                return [{
                        "data": {
                            status: process.env.SUCCESS_STATUS_V2,
                            "message": process.env.PAYMENT_METHOD,
                            "updated_values": await this.connection.query('SELECT * FROM payment_settings WHERE id = ?', [check.id])
                        }
                    }];
            }
            else {
                const results = await this.connection.query(`insert into payment_settings(payment_type,api_username,api_secret_key,salt,api_publishable_key,
    paytm_website,paytm_industrytype,api_password,api_signature,api_email,paypal_demo,account_no,is_active)
    values (?,?,?,?,?,?,?,?,?,?,?,?,?)`, [
                    SettingsPaymentMethodEntity.payment_type,
                    SettingsPaymentMethodEntity.api_username,
                    SettingsPaymentMethodEntity.api_secret_key,
                    SettingsPaymentMethodEntity.salt,
                    SettingsPaymentMethodEntity.api_publishable_key,
                    SettingsPaymentMethodEntity.paytm_website,
                    SettingsPaymentMethodEntity.paytm_industrytype,
                    SettingsPaymentMethodEntity.api_password,
                    SettingsPaymentMethodEntity.api_signature,
                    SettingsPaymentMethodEntity.api_email,
                    SettingsPaymentMethodEntity.paypal_demo,
                    SettingsPaymentMethodEntity.account_no,
                    SettingsPaymentMethodEntity.is_active
                ]);
                const [payment] = await this.connection.query(`select id from payment_settings where payment_type = ?`, [
                    SettingsPaymentMethodEntity.payment_type
                ]);
                await this.dynamicConnection.query(`insert into payment_settings(payment_type,api_username,api_secret_key,salt,api_publishable_key,
    paytm_website,paytm_industrytype,api_password,api_signature,api_email,paypal_demo,account_no,
    is_active,hos_payment_settings_id,hospital_id) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`, [
                    SettingsPaymentMethodEntity.payment_type,
                    SettingsPaymentMethodEntity.api_username,
                    SettingsPaymentMethodEntity.api_secret_key,
                    SettingsPaymentMethodEntity.salt,
                    SettingsPaymentMethodEntity.api_publishable_key,
                    SettingsPaymentMethodEntity.paytm_website,
                    SettingsPaymentMethodEntity.paytm_industrytype,
                    SettingsPaymentMethodEntity.api_password,
                    SettingsPaymentMethodEntity.api_signature,
                    SettingsPaymentMethodEntity.api_email,
                    SettingsPaymentMethodEntity.paypal_demo,
                    SettingsPaymentMethodEntity.account_no,
                    SettingsPaymentMethodEntity.is_active,
                    payment.id,
                    SettingsPaymentMethodEntity.hospital_id
                ]);
                return [{
                        "data": {
                            "id ": results.insertId,
                            status: process.env.SUCCESS_STATUS_V2,
                            messege: process.env.PAYMENT_SETTING,
                            "inserted_data": await this.connection.query('SELECT * FROM payment_settings WHERE id = ?', [results.insertId])
                        }
                    }];
            }
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SettingsPaymentMethodsService = SettingsPaymentMethodsService;
exports.SettingsPaymentMethodsService = SettingsPaymentMethodsService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SettingsPaymentMethodsService);
//# sourceMappingURL=settings_payment_methods.service.js.map