"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SettingsNotificationSettingService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let SettingsNotificationSettingService = class SettingsNotificationSettingService {
    constructor(connection) {
        this.connection = connection;
    }
    async findAll() {
        try {
            const notification_setting = await this.connection.query(`select notification_setting.id, notification_setting.type,notification_setting.is_mail,notification_setting.is_sms,notification_setting.is_mobileapp,
  notification_setting.template_id,notification_setting.template from notification_setting`);
            return notification_setting;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, SettingsNotificationSettingEntity) {
        try {
            await this.connection.query(`update notification_setting SET type = ?, template_id = ?, template = ?, is_mail = ?, is_sms = ?, is_mobileapp =?, subject=? where id = ?`, [
                SettingsNotificationSettingEntity.type,
                SettingsNotificationSettingEntity.template_id,
                SettingsNotificationSettingEntity.template,
                SettingsNotificationSettingEntity.is_mail,
                SettingsNotificationSettingEntity.is_sms,
                SettingsNotificationSettingEntity.is_mobileapp,
                SettingsNotificationSettingEntity.subject,
                id
            ]);
            return [{
                    "data": {
                        status: process.env.SUCCESS_STATUS_V2,
                        message: process.env.SETTING_NOTIFICATION_UPDATED,
                        "updated_values": await this.connection.query('select * from notification_setting where id = ?', [id])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SettingsNotificationSettingService = SettingsNotificationSettingService;
exports.SettingsNotificationSettingService = SettingsNotificationSettingService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], SettingsNotificationSettingService);
//# sourceMappingURL=settings_notification_setting.service.js.map