"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SettingsModuleService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SettingsModuleService = class SettingsModuleService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(createSettingsModuleDto) {
        try {
            const AddPermisionGroup = await this.connection.query(`insert into permission_group (name,short_code) 
        values (?,?)`, [
                createSettingsModuleDto.name,
                createSettingsModuleDto.short_code
            ]);
            await this.dynamicConnection.query(`insert into permission_group (name,
                short_code,
                hospital_id,
                hospital_permission_group_id
                ) 
        values (?,?,?,?)`, [
                createSettingsModuleDto.name,
                createSettingsModuleDto.short_code,
                createSettingsModuleDto.hospital_id,
                AddPermisionGroup.insertId
            ]);
            return {
                "status": process.env.SUCCESS_STATUS_V2,
                "message": process.env.MODULE
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const getAllModules = await this.connection.query(`select * from permission_group`);
            return getAllModules;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    findOne(id) {
        return `This action returns a #${id} settingsModule`;
    }
    async update(id, updateSettingsModuleDto) {
        try {
            await this.connection.query(`update permission_group set is_active = ? where id = ?`, [
                updateSettingsModuleDto.is_active, id
            ]);
            const [getAdminId] = await this.dynamicConnection.query(`select id from permission_group where hospital_id = ? and hospital_permission_group_id = ?`, [
                updateSettingsModuleDto.hospital_id,
                id
            ]);
            await this.dynamicConnection.query(`update permission_group set is_active = ? where id = ?`, [
                updateSettingsModuleDto.is_active,
                getAdminId.id
            ]);
            return {
                "status": process.env.SUCCESS_STATUS_V2,
                "message": process.env.MODULE_UPDATED
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    remove(id) {
        return `This action removes a #${id} settingsModule`;
    }
};
exports.SettingsModuleService = SettingsModuleService;
exports.SettingsModuleService = SettingsModuleService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SettingsModuleService);
//# sourceMappingURL=settings_module.service.js.map