"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SettingsUsersStaffsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let SettingsUsersStaffsService = class SettingsUsersStaffsService {
    constructor(connection) {
        this.connection = connection;
    }
    async findall() {
        try {
            const users_staff = await this.connection.query(`select staff.id,staff.employee_id as staff_ID, staff.name,staff.email,roles.name as role,staff_designation.designation,department.department_name,
    staff.contact_no as phone ,staff.is_active from staff
    join staff_roles on staff_roles.staff_id = staff.id
    join roles on staff_roles.role_id = roles.id
    join staff_designation on staff.staff_designation_id = staff_designation.id
    join department on staff.department_id = department.id`);
            return users_staff;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, SettingsUsersStaffEntity) {
        try {
            await this.connection.query(`update staff SET is_active = ? where id = ?`, [
                SettingsUsersStaffEntity.is_active,
                id
            ]);
            return [{ "data": {
                        status: process.env.SUCCESS_STATUS_V2,
                        message: process.env.USER_STAFF,
                        "updated_values": await this.connection.query(`select * from users where id = ?`, [id])
                    } }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SettingsUsersStaffsService = SettingsUsersStaffsService;
exports.SettingsUsersStaffsService = SettingsUsersStaffsService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], SettingsUsersStaffsService);
//# sourceMappingURL=settings-users-staffs.service.js.map