"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SettingsSystemNotificationSettingService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let SettingsSystemNotificationSettingService = class SettingsSystemNotificationSettingService {
    constructor(connection) {
        this.connection = connection;
    }
    async findAll() {
        try {
            const system_notification = await this.connection.query(`select system_notification_setting.id,system_notification_setting.event,system_notification_setting.subject,system_notification_setting.is_staff,
    system_notification_setting.is_patient,system_notification_setting.is_active,system_notification_setting.staff_message,
    system_notification_setting.patient_message from system_notification_setting`);
            return system_notification;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, SettingsSystemNotificationSettingEntity) {
        try {
            await this.connection.query(`update system_notification_setting SET subject = ?, staff_message = ?, patient_message =? where id = ?`, [
                SettingsSystemNotificationSettingEntity.subject,
                SettingsSystemNotificationSettingEntity.staff_message,
                SettingsSystemNotificationSettingEntity.patient_message,
                id
            ]);
            return [{
                    "data ": {
                        status: process.env.SUCCESS_STATUS_V2,
                        "messege": process.env.SYSTEM_NOTIFICATION,
                        "updated_values": await this.connection.query('SELECT * FROM system_notification_setting WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SettingsSystemNotificationSettingService = SettingsSystemNotificationSettingService;
exports.SettingsSystemNotificationSettingService = SettingsSystemNotificationSettingService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], SettingsSystemNotificationSettingService);
//# sourceMappingURL=settings-system_notification_setting.service.js.map