"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SettingsSmsSettingsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SettingsSmsSettingsService = class SettingsSmsSettingsService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(sms_Entity) {
        try {
            const [check] = await this.connection.query(`select id from sms_config where type = ?`, [sms_Entity.type]);
            if (check) {
                await this.connection.query(`update sms_config SET type = ?, name = ?, api_id = ?, authkey = ?, senderid = ?,
          contact = ?, username = ?, url = ?, password = ?, is_active = ? where id = ?`, [
                    sms_Entity.type,
                    sms_Entity.name,
                    sms_Entity.api_id,
                    sms_Entity.authkey,
                    sms_Entity.senderid,
                    sms_Entity.contact,
                    sms_Entity.username,
                    sms_Entity.url,
                    sms_Entity.password,
                    sms_Entity.is_active,
                    check.id
                ]);
                await this.dynamicConnection.query(`update sms_config SET type = ?, name = ?,api_id = ?, authkey = ?, senderid = ?,
          contact = ?, username = ?, url = ?, password = ?, is_active = ? where hos_sms_config_id = ? `, [
                    sms_Entity.type,
                    sms_Entity.name,
                    sms_Entity.api_id,
                    sms_Entity.authkey,
                    sms_Entity.senderid,
                    sms_Entity.contact,
                    sms_Entity.username,
                    sms_Entity.url,
                    sms_Entity.password,
                    sms_Entity.is_active,
                    check.id,
                ]);
                return [{
                        "data ": {
                            status: process.env.SUCCESS_STATUS_V2,
                            "message": process.env.SMS_CONFIG_UPDATED,
                            "updated_values": await this.connection.query('SELECT * FROM sms_config WHERE id = ?', [check.id])
                        }
                    }];
            }
            else {
                const result = await this.connection.query(`insert into sms_config(type,name,api_id,authkey,senderid,contact,username,url,password,is_active) 
  values (?,?,?,?,?,?,?,?,?,?)`, [
                    sms_Entity.type,
                    sms_Entity.name,
                    sms_Entity.api_id,
                    sms_Entity.authkey,
                    sms_Entity.senderid,
                    sms_Entity.contact,
                    sms_Entity.username,
                    sms_Entity.url,
                    sms_Entity.password,
                    sms_Entity.is_active
                ]);
                await this.dynamicConnection.query(`insert into sms_config (type,
          name,api_id,authkey,senderid,contact,username,url,password,is_active,hos_sms_config_id,hospital_id)
  values (?,?,?,?,?,?,?,?,?,?,?,?)`, [
                    sms_Entity.type,
                    sms_Entity.name,
                    sms_Entity.api_id,
                    sms_Entity.authkey,
                    sms_Entity.senderid,
                    sms_Entity.contact,
                    sms_Entity.username,
                    sms_Entity.url,
                    sms_Entity.password,
                    sms_Entity.is_active,
                    result.insertId,
                    sms_Entity.hospital_id
                ]);
                return [{
                        "data ": {
                            "id  ": result.insertId,
                            "status": process.env.SUCCESS_STATUS_V2,
                            "messege": process.env.SMS_CONFIG,
                            "inserted_data": await this.connection.query('SELECT * FROM sms_config WHERE id = ?', [result.insertId])
                        }
                    }];
            }
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async find_one(id) {
        try {
            const sms = await this.connection.query(`select * from sms_config where id = ?`, [id]);
            return sms;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SettingsSmsSettingsService = SettingsSmsSettingsService;
exports.SettingsSmsSettingsService = SettingsSmsSettingsService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SettingsSmsSettingsService);
//# sourceMappingURL=settings-sms-settings.service.js.map