"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SettingsModulesPatientService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let SettingsModulesPatientService = class SettingsModulesPatientService {
    constructor(connection) {
        this.connection = connection;
    }
    async findall() {
        try {
            const modules_patient = await this.connection.query(`select permission_patient.id,permission_patient.name,permission_patient.is_active from permission_patient`);
            return modules_patient;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, SettingsModulesPatientEntity) {
        try {
            await this.connection.query(`update permission_patient SET is_active = ? where id = ?`, [
                SettingsModulesPatientEntity.is_active,
                id
            ]);
            return [{
                    "date": {
                        status: process.env.SUCCESS_STATUS_V2,
                        "message": process.env.PERMISSION_PATIENT,
                        "updated_values": await this.connection.query(`select * from permission_patient where id = ?`, [id])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SettingsModulesPatientService = SettingsModulesPatientService;
exports.SettingsModulesPatientService = SettingsModulesPatientService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], SettingsModulesPatientService);
//# sourceMappingURL=settings-modules_patient.service.js.map