"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SettingsFrontCmsSettingService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let SettingsFrontCmsSettingService = class SettingsFrontCmsSettingService {
    constructor(connection) {
        this.connection = connection;
    }
    async findall() {
        try {
            const front_cms_settings = await this.connection.query(`select front_cms_settings.id, front_cms_settings.is_active_front_cms,front_cms_settings.is_active_online_appointment,front_cms_settings.is_active_sidebar,
    front_cms_settings.is_active_rtl,front_cms_settings.sidebar_options,front_cms_settings.logo,front_cms_settings.fav_icon,
    front_cms_settings.footer_text,front_cms_settings.google_analytics,
    front_cms_settings.fb_url,front_cms_settings.twitter_url,front_cms_settings.youtube_url,front_cms_settings.google_plus,
    front_cms_settings.linkedin_url,front_cms_settings.instagram_url,front_cms_settings.pinterest_url,front_cms_settings.theme from front_cms_settings`);
            return front_cms_settings;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, SettingsFrontCmsSettingEntity) {
        try {
            await this.connection.query(`update front_cms_settings set theme =?, is_active_rtl = ?, is_active_front_cms = ?,
        is_active_online_appointment=?, is_active_sidebar=?, logo=?,contact_us_email=?,
        complain_form_email=?, sidebar_options=?, fb_url=?,twitter_url=?,youtube_url=?,
        google_plus=?, instagram_url=?,pinterest_url=?, linkedin_url=?,google_analytics=?,
        footer_text=?,fav_icon=? where id = ?`, [
                SettingsFrontCmsSettingEntity.theme,
                SettingsFrontCmsSettingEntity.is_active_rtl,
                SettingsFrontCmsSettingEntity.is_active_front_cms,
                SettingsFrontCmsSettingEntity.is_active_online_appointment,
                SettingsFrontCmsSettingEntity.is_active_sidebar,
                SettingsFrontCmsSettingEntity.logo,
                SettingsFrontCmsSettingEntity.contact_us_email,
                SettingsFrontCmsSettingEntity.complain_form_email,
                SettingsFrontCmsSettingEntity.sidebar_options,
                SettingsFrontCmsSettingEntity.fb_url,
                SettingsFrontCmsSettingEntity.twitter_url,
                SettingsFrontCmsSettingEntity.youtube_url,
                SettingsFrontCmsSettingEntity.google_plus,
                SettingsFrontCmsSettingEntity.instagram_url,
                SettingsFrontCmsSettingEntity.pinterest_url,
                SettingsFrontCmsSettingEntity.linkedin_url,
                SettingsFrontCmsSettingEntity.google_analytics,
                SettingsFrontCmsSettingEntity.footer_text,
                SettingsFrontCmsSettingEntity.fav_icon,
                id
            ]);
            return [{
                    "data": {
                        status: process.env.SUCCESS_STATUS_V2,
                        "message": process.env.FRONT_CMS_SETTING_UPDATED,
                        "updated_values": await this.connection.query(`select * from front_cms_settings where id = ?`, [id])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SettingsFrontCmsSettingService = SettingsFrontCmsSettingService;
exports.SettingsFrontCmsSettingService = SettingsFrontCmsSettingService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], SettingsFrontCmsSettingService);
//# sourceMappingURL=settings-front_cms_setting.service.js.map