"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SettingPrefixSettingService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let SettingPrefixSettingService = class SettingPrefixSettingService {
    constructor(connection) {
        this.connection = connection;
    }
    async create(prefix_setting_entity) {
        try {
            const result = await this.connection.query(`insert into prefixes (type,prefix) values (?,?)`, [prefix_setting_entity.type,
                prefix_setting_entity.prefix]);
            return [{
                    "data ": {
                        "id  ": result.insertId,
                        "status": process.env.SUCCESS_STATUS_V2,
                        "messege": process.env.PREFIX_DETAILS,
                        "inserted_data": await this.connection.query('SELECT * FROM prefixes WHERE id = ?', [result.insertId])
                    }
                }];
            ;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findall() {
        try {
            const prefix_setting = await this.connection.query(`select prefixes.id,prefixes.type, prefixes.prefix from prefixes`);
            return prefix_setting;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, SettingPrefixSettingServiceEntity) {
        try {
            await this.connection.query(`update prefixes SET prefix = ? where id = ?`, [
                SettingPrefixSettingServiceEntity.prefix,
                id
            ]);
            return [{
                    "data ": {
                        status: process.env.SUCCESS_STATUS_V2,
                        message: process.env.DELETED,
                        "updated_values": await this.connection.query('SELECT * FROM prefixes WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SettingPrefixSettingService = SettingPrefixSettingService;
exports.SettingPrefixSettingService = SettingPrefixSettingService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], SettingPrefixSettingService);
//# sourceMappingURL=setting-prefix_setting.service.js.map