"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SettingLanguagesService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let SettingLanguagesService = class SettingLanguagesService {
    constructor(connection) {
        this.connection = connection;
    }
    async create(setting_languageEntity) {
        try {
            const result = await this.connection.query('insert into languages (language,short_code,country_code) values (?,?,?)', [
                setting_languageEntity.language,
                setting_languageEntity.short_code,
                setting_languageEntity.country_code
            ]);
            return [{
                    "data ": {
                        "id  ": result.insertId,
                        "status": process.env.SUCCESS_STATUS_V2,
                        "messege": process.env.LANGUAGE,
                        "inserted_data": await this.connection.query('SELECT * FROM languages WHERE id = ?', [result.insertId])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findall() {
        try {
            const SettingLanguage = await this.connection.query(`select languages.id,languages.language,languages.short_code,languages.country_code,languages.is_deleted,
    languages.is_rtl,languages.is_active from languages `);
            return SettingLanguage;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, SettingLanguageEntity) {
        try {
            await this.connection.query(`update languages SET is_deleted = ?, is_rtl = ?,is_active = ? where id = ?`, [
                SettingLanguageEntity.is_deleted,
                SettingLanguageEntity.is_rtl,
                SettingLanguageEntity.is_active,
                id
            ]);
            return [{
                    "data ": {
                        status: process.env.SUCCESS_STATUS_V2,
                        "messege": process.env.LANGUAGE_UPDATED,
                        "updated_values": await this.connection.query('SELECT * FROM languages WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SettingLanguagesService = SettingLanguagesService;
exports.SettingLanguagesService = SettingLanguagesService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], SettingLanguagesService);
//# sourceMappingURL=setting-languages.service.js.map