"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SarvamJobOpdIdMappingService = void 0;
const common_1 = require("@nestjs/common");
const event_emitter_1 = require("@nestjs/event-emitter");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SarvamJobOpdIdMappingService = class SarvamJobOpdIdMappingService {
    constructor(dynamicConnection, connection, eventEmitter) {
        this.dynamicConnection = dynamicConnection;
        this.connection = connection;
        this.eventEmitter = eventEmitter;
    }
    async create(createSarvamJobOpdIdMappingDto) {
        const insertQuery = `INSERT INTO sarvam_job_id_opd_id (sarvam_job_id, opd_id) values (?, ?)`;
        const values = [
            createSarvamJobOpdIdMappingDto.job_id,
            createSarvamJobOpdIdMappingDto.opd_id,
        ];
        await this.dynamicConnection.query(insertQuery, values);
        return {
            status: 'success',
            message: 'Sarvam Job Opd Id Mapping created successfully',
        };
    }
    async findAll(opd_id) {
        const getData = await this.dynamicConnection.query(`select sarvam_job_id from sarvam_job_id_opd_id where opd_id  = ? order by created_at desc `, [opd_id]);
        return {
            status: 'success',
            message: 'Sarvam Job Opd Id Mapping fetched successfully',
            data: getData,
        };
    }
    findOne(id) {
        return `This action returns a #${id} sarvamJobOpdIdMapping`;
    }
    update(id, updateSarvamJobOpdIdMappingDto) {
        return `This action updates a #${id} sarvamJobOpdIdMapping`;
    }
    remove(id) {
        return `This action removes a #${id} sarvamJobOpdIdMapping`;
    }
};
exports.SarvamJobOpdIdMappingService = SarvamJobOpdIdMappingService;
exports.SarvamJobOpdIdMappingService = SarvamJobOpdIdMappingService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource,
        event_emitter_1.EventEmitter2])
], SarvamJobOpdIdMappingService);
//# sourceMappingURL=sarvam_job_opd_id_mapping.service.js.map