"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReferralPersonCommissionService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let ReferralPersonCommissionService = class ReferralPersonCommissionService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(createReferralPersonCommission) {
        try {
            const results = [];
            for (const referral_person_commissionEntity of createReferralPersonCommission) {
                const result = await this.connection.query('INSERT INTO referral_person_commission(referral_person_id, referral_type_id, commission) VALUES (?, ?, ?)', [
                    referral_person_commissionEntity.referral_person_id,
                    referral_person_commissionEntity.referral_type_id,
                    referral_person_commissionEntity.commission
                ]);
                const [referral_Person] = await this.dynamicConnection.query(`select id from referral_person where Hospital_id = ? and  hos_referral_person_id = ?`, [
                    referral_person_commissionEntity.Hospital_id,
                    referral_person_commissionEntity.referral_person_id
                ]);
                const [referral_type] = await this.dynamicConnection.query(`select id from referral_type where Hospital_id = ? and hospital_referral_type_id = ?`, [
                    referral_person_commissionEntity.Hospital_id,
                    referral_person_commissionEntity.referral_type_id
                ]);
                await this.dynamicConnection.query(`Insert into referral_person_commission (referral_person_id, referral_type_id, commission,hos_referral_person_commission_id,Hospital_id) values (?,?,?,?,?)`, [
                    referral_Person.id,
                    referral_type.id,
                    referral_person_commissionEntity.commission,
                    result.insertId,
                    referral_person_commissionEntity.Hospital_id
                ]);
                results.push(result);
            }
            return results;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(updateReferralPersonCommission) {
        try {
            const results = [];
            for (const referral_commissionEntity of updateReferralPersonCommission) {
                const existingRecord = await this.connection.query('SELECT id FROM referral_person_commission WHERE referral_person_id = ? AND referral_type_id = ?', [
                    referral_commissionEntity.referral_person_id,
                    referral_commissionEntity.referral_type_id
                ]);
                if (existingRecord.length > 0) {
                    const result = await this.connection.query('UPDATE referral_person_commission SET commission = ? WHERE referral_person_id = ? AND referral_type_id = ?', [
                        referral_commissionEntity.commission,
                        referral_commissionEntity.referral_person_id,
                        referral_commissionEntity.referral_type_id
                    ]);
                    results.push(result);
                }
                else {
                    const result = await this.connection.query('INSERT INTO referral_person_commission (referral_person_id, referral_type_id, commission) VALUES (?, ?, ?)', [
                        referral_commissionEntity.referral_person_id,
                        referral_commissionEntity.referral_type_id,
                        referral_commissionEntity.commission
                    ]);
                    results.push(result);
                }
                const [update_admin_referral_Person] = await this.dynamicConnection.query(`select id from referral_person where Hospital_id = ? and  hos_referral_person_id = ?`, [
                    referral_commissionEntity.Hospital_id,
                    referral_commissionEntity.referral_person_id
                ]);
                const [update_admin_referral_type] = await this.dynamicConnection.query(`select id from referral_type where Hospital_id = ? and hospital_referral_type_id = ?`, [
                    referral_commissionEntity.Hospital_id,
                    referral_commissionEntity.referral_type_id
                ]);
                const AdminexistingRecord = await this.dynamicConnection.query('SELECT id FROM referral_person_commission WHERE referral_person_id = ? AND referral_type_id = ?', [
                    update_admin_referral_Person.id,
                    update_admin_referral_type.id
                ]);
                if (AdminexistingRecord.length > 0) {
                    const result = await this.dynamicConnection.query('UPDATE referral_person_commission SET commission = ? WHERE referral_person_id = ? AND referral_type_id = ?', [
                        referral_commissionEntity.commission,
                        update_admin_referral_Person.id,
                        update_admin_referral_type.id
                    ]);
                    results.push(result);
                }
                else {
                    const result = await this.dynamicConnection.query('INSERT INTO referral_person_commission (referral_person_id, referral_type_id, commission) VALUES (?, ?, ?)', [
                        update_admin_referral_Person.id,
                        update_admin_referral_type.id,
                        referral_commissionEntity.commission
                    ]);
                    results.push(result);
                }
            }
            return results;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.ReferralPersonCommissionService = ReferralPersonCommissionService;
exports.ReferralPersonCommissionService = ReferralPersonCommissionService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], ReferralPersonCommissionService);
//# sourceMappingURL=referral_person_commission.service.js.map