"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReferralPersonService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let ReferralPersonService = class ReferralPersonService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(createReferralPerson) {
        try {
            const addReferralPerson = await this.connection.query(`INSERT into referral_person(
        name,
        category_id,
        contact,
        person_name,
        person_phone,
        standard_commission,
        address
      ) VALUES (?,?,?,?,?,?,?)`, [
                createReferralPerson.name,
                createReferralPerson.category_id,
                createReferralPerson.contact,
                createReferralPerson.person_name,
                createReferralPerson.person_phone,
                createReferralPerson.standard_commission,
                createReferralPerson.address
            ]);
            const addedReferralPersonId = addReferralPerson.insertId;
            const dynnncategoryid = await this.dynamicConnection.query('SELECT id FROM referral_category WHERE hospital_referral_category_id = ? and Hospital_id = ?', [createReferralPerson.category_id, createReferralPerson.Hospital_id]);
            const dynnnCateid = dynnncategoryid[0].id;
            await this.dynamicConnection.query(`INSERT into referral_person(
       name,
       category_id,
       contact,
       person_name,
       person_phone,
       standard_commission,
       address,
       hos_referral_person_id,
       Hospital_id
     ) VALUES (?,?,?,?,?,?,?,?,?)`, [
                createReferralPerson.name,
                dynnnCateid,
                createReferralPerson.contact,
                createReferralPerson.person_name,
                createReferralPerson.person_phone,
                createReferralPerson.standard_commission,
                createReferralPerson.address,
                addedReferralPersonId,
                createReferralPerson.Hospital_id
            ]);
            return [{
                    "data ": {
                        status: process.env.SUCCESS_STATUS_V2,
                        "messege": process.env.REFERRAL_PERSON,
                        "Added_values": await this.connection.query('SELECT * FROM referral_person WHERE id = ?', [addedReferralPersonId])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, createReferralPerson) {
        try {
            await this.connection.query(`UPDATE referral_person SET
        name=?,
        category_id=?,
        contact=?,
        person_name=?,
        person_phone=?,
        standard_commission=?,
        address=?
        WHERE id = ?
        `, [
                createReferralPerson.name,
                createReferralPerson.category_id,
                createReferralPerson.contact,
                createReferralPerson.person_name,
                createReferralPerson.person_phone,
                createReferralPerson.standard_commission,
                createReferralPerson.address,
                id
            ]);
            const dynnnAdmincategoryid = await this.dynamicConnection.query('SELECT id FROM referral_category WHERE hospital_referral_category_id = ? and Hospital_id = ?', [createReferralPerson.category_id, createReferralPerson.Hospital_id]);
            const dynnnADMINCateid = dynnnAdmincategoryid[0].id;
            const dynnnAdminrefPersonid = await this.dynamicConnection.query('SELECT id FROM referral_person WHERE hos_referral_person_id = ? and Hospital_id = ?', [id, createReferralPerson.Hospital_id]);
            const dynnnAdminrefPersonidddd = dynnnAdminrefPersonid[0].id;
            await this.dynamicConnection.query(`UPDATE referral_person SET
        name=?,
        category_id=?,
        contact=?,
        person_name=?,
        person_phone=?,
        standard_commission=?,
        address=?,
        Hospital_id=?
        WHERE id = ?
        `, [
                createReferralPerson.name,
                dynnnADMINCateid,
                createReferralPerson.contact,
                createReferralPerson.person_name,
                createReferralPerson.person_phone,
                createReferralPerson.standard_commission,
                createReferralPerson.address,
                createReferralPerson.Hospital_id,
                dynnnAdminrefPersonidddd
            ]);
            return [{
                    "data ": {
                        status: process.env.SUCCESS_STATUS_V2,
                        "messege": process.env.REFERRAL_PERSON_UPDATED,
                        "Updated_values": await this.connection.query('SELECT * FROM referral_person WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const getReferralPersonDetails = await this.connection.query(`SELECT
    rp.id,
    rp.name,
    GROUP_CONCAT(CONCAT(rt.name, ' - ', RPC.commission, '%') ORDER BY rc.name SEPARATOR '\n') AS commission,
    rc.name AS category_name,
    rp.contact AS referralcontact,
    rp.person_name AS contactpersonname,
    rp.person_phone AS contactpersonphone,
    rp.address
FROM referral_person rp
LEFT JOIN referral_category rc ON rp.category_id = rc.id
LEFT JOIN referral_person_commission RPC ON rp.id = RPC.referral_person_id
LEFT JOIN referral_type rt ON RPC.referral_type_id = rt.id
GROUP BY rp.id,rp.name, rc.name, rp.contact, rp.person_name, rp.person_phone, rp.address`);
            return getReferralPersonDetails;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findreferralPersonSearch(search) {
        try {
            let query = `SELECT
    rp.id,
    rp.name,
    GROUP_CONCAT(CONCAT(rt.name, ' - ', RPC.commission, '%') ORDER BY rc.name SEPARATOR '\n') AS commission,
    rc.name AS category_name,
    rp.contact AS referralcontact,
    rp.person_name AS contactpersonname,
    rp.person_phone AS contactpersonphone,
    rp.address
FROM referral_person rp
LEFT JOIN referral_category rc ON rp.category_id = rc.id
LEFT JOIN referral_person_commission RPC ON rp.id = RPC.referral_person_id
LEFT JOIN referral_type rt ON RPC.referral_type_id = rt.id
where rp.id
`;
            let values = [];
            if (search) {
                query += ` and  (rp.name like ? or rc.name like ? or rp.contact like ? or rp.person_name like ? or rp.person_phone like ? or rp.address like ?)  `;
                values.push("%" + search + "%");
                values.push("%" + search + "%");
                values.push("%" + search + "%");
                values.push("%" + search + "%");
                values.push("%" + search + "%");
                values.push("%" + search + "%");
            }
            let last = `GROUP BY rp.id,rp.name, rc.name, rp.contact, rp.person_name, rp.person_phone, rp.address`;
            let final = query + last;
            const getReferralPersonsch = await this.connection.query(final, values);
            return getReferralPersonsch;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(referral_person_id, Hospital_id) {
        try {
            await this.connection.query('DELETE FROM referral_person_commission WHERE referral_person_id = ?', [referral_person_id]);
            await this.connection.query('DELETE FROM referral_person WHERE id = ?', [referral_person_id]);
            const adminreferralPerson = await this.dynamicConnection.query(`select id from referral_person where hos_referral_person_id = ? and Hospital_id = ?`, [referral_person_id, Hospital_id]);
            const adminReferralPersonID = adminreferralPerson[0].id;
            await this.dynamicConnection.query(`delete from referral_person_commission where referral_person_id = ?`, [adminReferralPersonID]);
            await this.dynamicConnection.query(`delete from referral_person where id = ?`, [adminReferralPersonID]);
            return [{
                    "status": process.env.SUCCESS_STATUS_V2,
                    "message": process.env.DELETED
                }
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findRefCategory() {
        try {
            const ReferralCategory = await this.connection.query('SELECT id,name from referral_category');
            return ReferralCategory;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.ReferralPersonService = ReferralPersonService;
exports.ReferralPersonService = ReferralPersonService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], ReferralPersonService);
//# sourceMappingURL=referral_person.service.js.map