"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReferralPersonController = void 0;
const common_1 = require("@nestjs/common");
const referral_person_service_1 = require("./referral_person.service");
const referral_person_entity_1 = require("./entities/referral_person.entity");
const auth_guard_1 = require("../auth/auth.guard");
let ReferralPersonController = class ReferralPersonController {
    constructor(referralPersonService) {
        this.referralPersonService = referralPersonService;
    }
    create(createReferralPerson) {
        return this.referralPersonService.create(createReferralPerson);
    }
    update(id, createReferralPerson) {
        return this.referralPersonService.update(id, createReferralPerson);
    }
    findAll() {
        return this.referralPersonService.findAll();
    }
    findreferralPersonSearch(search) {
        return this.referralPersonService.findreferralPersonSearch(search);
    }
    async remove(referral_person_id, Hospital_id) {
        const deletereferral_person_commission = await this.referralPersonService.remove(referral_person_id, Hospital_id);
        return {
            status: `success`,
            message: `id: ${referral_person_id} deleted successfully`
        };
    }
    findRefCategory() {
        return this.referralPersonService.findRefCategory();
    }
};
exports.ReferralPersonController = ReferralPersonController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [referral_person_entity_1.ReferralPerson]),
    __metadata("design:returntype", void 0)
], ReferralPersonController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, referral_person_entity_1.ReferralPerson]),
    __metadata("design:returntype", void 0)
], ReferralPersonController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ReferralPersonController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/filter'),
    __param(0, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ReferralPersonController.prototype, "findreferralPersonSearch", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/:referral_person_id'),
    __param(0, (0, common_1.Param)('referral_person_id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", Promise)
], ReferralPersonController.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/refCat'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ReferralPersonController.prototype, "findRefCategory", null);
exports.ReferralPersonController = ReferralPersonController = __decorate([
    (0, common_1.Controller)('referral-person'),
    __metadata("design:paramtypes", [referral_person_service_1.ReferralPersonService])
], ReferralPersonController);
//# sourceMappingURL=referral_person.controller.js.map