"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReferralPaymentController = void 0;
const common_1 = require("@nestjs/common");
const referral_payment_service_1 = require("./referral_payment.service");
const referral_payment_entity_1 = require("./entities/referral_payment.entity");
const auth_guard_1 = require("../auth/auth.guard");
let ReferralPaymentController = class ReferralPaymentController {
    constructor(referralPaymentService) {
        this.referralPaymentService = referralPaymentService;
    }
    create(createReferralPayment) {
        return this.referralPaymentService.create(createReferralPayment);
    }
    findopdidcaseid(patient_id, section) {
        return this.referralPaymentService.findopdidcaseid(patient_id, section);
    }
    findrefPatBillAmount(opd_id, case_reference_id) {
        return this.referralPaymentService.findrefPatBillAmount(opd_id, case_reference_id);
    }
    async getCommissionAmount(id, amount) {
        return this.referralPaymentService.getCommissionAmount(id, amount);
    }
    findAll() {
        return this.referralPaymentService.findAll();
    }
    ReferralPaymentSearch(search) {
        return this.referralPaymentService.ReferralPaymentSearch(search);
    }
    async remove(referral_payment_id, Hospital_id) {
        const deletereferral_payment = await this.referralPaymentService.remove(referral_payment_id, Hospital_id);
        return {
            status: `success`,
            message: `id: ${referral_payment_id} deleted successfully`
        };
    }
    update(id, createReferralPayment) {
        return this.referralPaymentService.update(id, createReferralPayment);
    }
};
exports.ReferralPaymentController = ReferralPaymentController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [referral_payment_entity_1.ReferralPayment]),
    __metadata("design:returntype", void 0)
], ReferralPaymentController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/opdidcaseid/:patient_id'),
    __param(0, (0, common_1.Param)('patient_id')),
    __param(1, (0, common_1.Query)('section')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String]),
    __metadata("design:returntype", void 0)
], ReferralPaymentController.prototype, "findopdidcaseid", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/patientBillAmount'),
    __param(0, (0, common_1.Query)('opd_id')),
    __param(1, (0, common_1.Query)('case_reference_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], ReferralPaymentController.prototype, "findrefPatBillAmount", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('commission'),
    __param(0, (0, common_1.Query)('id')),
    __param(1, (0, common_1.Query)('amount')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], ReferralPaymentController.prototype, "getCommissionAmount", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ReferralPaymentController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/referralPayment/:search'),
    __param(0, (0, common_1.Param)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ReferralPaymentController.prototype, "ReferralPaymentSearch", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)(),
    __param(0, (0, common_1.Query)('referral_payment_id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", Promise)
], ReferralPaymentController.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, referral_payment_entity_1.ReferralPayment]),
    __metadata("design:returntype", void 0)
], ReferralPaymentController.prototype, "update", null);
exports.ReferralPaymentController = ReferralPaymentController = __decorate([
    (0, common_1.Controller)('referral-payment'),
    __metadata("design:paramtypes", [referral_payment_service_1.ReferralPaymentService])
], ReferralPaymentController);
//# sourceMappingURL=referral_payment.controller.js.map