"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RadiologyTestController = void 0;
const common_1 = require("@nestjs/common");
const radiology_test_service_1 = require("./radiology_test.service");
const radiology_test_entity_1 = require("./entities/radiology_test.entity");
const auth_guard_1 = require("../auth/auth.guard");
let RadiologyTestController = class RadiologyTestController {
    constructor(radiologyTestService) {
        this.radiologyTestService = radiologyTestService;
    }
    create(createRadiologyTest) {
        return this.radiologyTestService.create(createRadiologyTest);
    }
    createRadiologyParameterDetails(createRadiologyTest) {
        return this.radiologyTestService.createRadiologyParameterDetails(createRadiologyTest);
    }
    updateRadio(id, createRadiologyTest) {
        return this.radiologyTestService.updateRadio(id, createRadiologyTest);
    }
    updateRadiologyParameterDetails(createRadiologyTest) {
        return this.radiologyTestService.updateRadiologyParameterDetails(createRadiologyTest);
    }
    async removeRadiology(id, hospital_id) {
        await this.radiologyTestService.removeRadiology(id, hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    async removeRadiologyparameterdetails(id, hospital_id) {
        await this.radiologyTestService.removeRadiologyparameterdetails(id, hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
};
exports.RadiologyTestController = RadiologyTestController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [radiology_test_entity_1.RadiologyTest]),
    __metadata("design:returntype", void 0)
], RadiologyTestController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('/radiologyParameterDetails'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", void 0)
], RadiologyTestController.prototype, "createRadiologyParameterDetails", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, radiology_test_entity_1.RadiologyTest]),
    __metadata("design:returntype", void 0)
], RadiologyTestController.prototype, "updateRadio", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/editRadioParameter/details'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", void 0)
], RadiologyTestController.prototype, "updateRadiologyParameterDetails", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], RadiologyTestController.prototype, "removeRadiology", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/deleteRadilogyparameterdetails/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], RadiologyTestController.prototype, "removeRadiologyparameterdetails", null);
exports.RadiologyTestController = RadiologyTestController = __decorate([
    (0, common_1.Controller)('radiology-test'),
    __metadata("design:paramtypes", [radiology_test_service_1.RadiologyTestService])
], RadiologyTestController);
//# sourceMappingURL=radiology_test.controller.js.map