"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RadiologyGenerateBillController = void 0;
const common_1 = require("@nestjs/common");
const radiology_generate_bill_service_1 = require("./radiology_generate_bill.service");
const radiology_generate_bill_entity_1 = require("./entities/radiology_generate_bill.entity");
const auth_guard_1 = require("../auth/auth.guard");
let RadiologyGenerateBillController = class RadiologyGenerateBillController {
    constructor(radiologyGenerateBillService) {
        this.radiologyGenerateBillService = radiologyGenerateBillService;
    }
    create(createRadiologyGenerateBill) {
        return this.radiologyGenerateBillService.create(createRadiologyGenerateBill);
    }
    createRadiologyReport(createRadiologyGenerateBill) {
        return this.radiologyGenerateBillService.createRadiologyReport(createRadiologyGenerateBill);
    }
    AddRadiologyPayment(createRadiologyGenerateBill) {
        return this.radiologyGenerateBillService.AddRadiologyPayment(createRadiologyGenerateBill);
    }
    async removeRadiologyBill(id, hospital_id) {
        await this.radiologyGenerateBillService.removeRadiologyBill(id, hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    async deleteRadioPayment(id, Hospital_id) {
        await this.radiologyGenerateBillService.deleteRadioPayment(id, Hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    async removeRadioreport(id, hospital_id) {
        await this.radiologyGenerateBillService.removeRadioreport(id, hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    updateRadiologyBilling(id, createRadiologyGenerateBill) {
        return this.radiologyGenerateBillService.updateRadiologyBilling(id, createRadiologyGenerateBill);
    }
    updateRadiologyReport(createRadiologyGenerateBill) {
        return this.radiologyGenerateBillService.updateRadiologyReport(createRadiologyGenerateBill);
    }
    updateCollectedPerson(id, createRadiologyGenerateBill) {
        return this.radiologyGenerateBillService.updateCollectedPerson(id, createRadiologyGenerateBill);
    }
    updateApprovalByPerson(id, createRadiologyGenerateBill) {
        return this.radiologyGenerateBillService.updateApprovalByPerson(id, createRadiologyGenerateBill);
    }
};
exports.RadiologyGenerateBillController = RadiologyGenerateBillController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [radiology_generate_bill_entity_1.RadiologyGenerateBill]),
    __metadata("design:returntype", void 0)
], RadiologyGenerateBillController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('/radiologyReport'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", void 0)
], RadiologyGenerateBillController.prototype, "createRadiologyReport", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('/AddRadiologyPayment'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [radiology_generate_bill_entity_1.RadiologyGenerateBill]),
    __metadata("design:returntype", void 0)
], RadiologyGenerateBillController.prototype, "AddRadiologyPayment", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], RadiologyGenerateBillController.prototype, "removeRadiologyBill", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/deleteRadioPayment/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], RadiologyGenerateBillController.prototype, "deleteRadioPayment", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/removeRadioreport/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], RadiologyGenerateBillController.prototype, "removeRadioreport", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, radiology_generate_bill_entity_1.RadiologyGenerateBill]),
    __metadata("design:returntype", void 0)
], RadiologyGenerateBillController.prototype, "updateRadiologyBilling", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/radioReport/reportUpdate/editradiologyReports'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", void 0)
], RadiologyGenerateBillController.prototype, "updateRadiologyReport", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/updateCollectedPerson/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, radiology_generate_bill_entity_1.RadiologyGenerateBill]),
    __metadata("design:returntype", void 0)
], RadiologyGenerateBillController.prototype, "updateCollectedPerson", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/updateApprovalByPerson/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, radiology_generate_bill_entity_1.RadiologyGenerateBill]),
    __metadata("design:returntype", void 0)
], RadiologyGenerateBillController.prototype, "updateApprovalByPerson", null);
exports.RadiologyGenerateBillController = RadiologyGenerateBillController = __decorate([
    (0, common_1.Controller)('radiology-generate-bill'),
    __metadata("design:paramtypes", [radiology_generate_bill_service_1.RadiologyGenerateBillService])
], RadiologyGenerateBillController);
//# sourceMappingURL=radiology_generate_bill.controller.js.map