"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PurchaseMedicineController = void 0;
const common_1 = require("@nestjs/common");
const purchase_medicine_service_1 = require("./purchase_medicine.service");
const purchase_medicine_entity_1 = require("./entities/purchase_medicine.entity");
const auth_guard_1 = require("../auth/auth.guard");
let PurchaseMedicineController = class PurchaseMedicineController {
    constructor(purchaseMedicineService) {
        this.purchaseMedicineService = purchaseMedicineService;
    }
    create(createPurchaseMedicine) {
        return this.purchaseMedicineService.create(createPurchaseMedicine);
    }
    createMedicineBatchDetails(createPurchaseMedicine) {
        return this.purchaseMedicineService.createMedicineBatchDetails(createPurchaseMedicine);
    }
    findAll() {
        return this.purchaseMedicineService.findAll();
    }
    findPurchaseMedicine(search) {
        return this.purchaseMedicineService.findPurchaseMedicine(search);
    }
    findOne(id) {
        return this.purchaseMedicineService.findOne(id);
    }
    async removePurchaseMedicine(id, hospital_id) {
        await this.purchaseMedicineService.removePurchaseMedicine(id, hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    findMedicineSupplier() {
        return this.purchaseMedicineService.findMedicineSupplier();
    }
    findMedicineCategory() {
        return this.purchaseMedicineService.findMedicineCategory();
    }
    findMedicineName(id) {
        return this.purchaseMedicineService.findMedicineName(id);
    }
    findTaxByMedicineName(id) {
        return this.purchaseMedicineService.findTaxByMedicineName(id);
    }
};
exports.PurchaseMedicineController = PurchaseMedicineController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [purchase_medicine_entity_1.PurchaseMedicine]),
    __metadata("design:returntype", void 0)
], PurchaseMedicineController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('/medicineBatchDetails'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", void 0)
], PurchaseMedicineController.prototype, "createMedicineBatchDetails", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PurchaseMedicineController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/purchase/:search'),
    __param(0, (0, common_1.Param)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PurchaseMedicineController.prototype, "findPurchaseMedicine", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PurchaseMedicineController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], PurchaseMedicineController.prototype, "removePurchaseMedicine", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/medicine/supplier'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PurchaseMedicineController.prototype, "findMedicineSupplier", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/medicine/category'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PurchaseMedicineController.prototype, "findMedicineCategory", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/findMedicine/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], PurchaseMedicineController.prototype, "findMedicineName", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/findMedicineTax/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], PurchaseMedicineController.prototype, "findTaxByMedicineName", null);
exports.PurchaseMedicineController = PurchaseMedicineController = __decorate([
    (0, common_1.Controller)('purchase-medicine'),
    __metadata("design:paramtypes", [purchase_medicine_service_1.PurchaseMedicineService])
], PurchaseMedicineController);
//# sourceMappingURL=purchase_medicine.controller.js.map