"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrintSettingService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let PrintSettingService = class PrintSettingService {
    constructor(connection) {
        this.connection = connection;
    }
    async getPrintSettingById(id) {
        const result = await this.connection.query(`SELECT * FROM print_setting WHERE id = ?`, [id]);
        return result.length ? result[0] : null;
    }
    async updateSettingFor(settings) {
        const { id, print_header, print_footer, setting_for, is_active } = settings;
        try {
            await this.connection.query(`UPDATE print_setting SET 
          print_header = ?, 
          print_footer = ?, 
          setting_for = ?, 
          is_active = ? 
        WHERE id = ?`, [print_header, print_footer, setting_for, is_active, id]);
            return { status: 'success', message: 'Print setting updated successfully' };
        }
        catch (error) {
            return { status: 'failed', message: 'Update failed', error };
        }
    }
};
exports.PrintSettingService = PrintSettingService;
exports.PrintSettingService = PrintSettingService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], PrintSettingService);
//# sourceMappingURL=print_setting.service.js.map