"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrintSettingController = void 0;
const common_1 = require("@nestjs/common");
const print_setting_service_1 = require("./print_setting.service");
const print_setting_entity_1 = require("./entities/print_setting.entity");
const auth_guard_1 = require("../auth/auth.guard");
let PrintSettingController = class PrintSettingController {
    constructor(printSettingService) {
        this.printSettingService = printSettingService;
    }
    async getPrintSettingById(id) {
        const setting = await this.printSettingService.getPrintSettingById(id);
        if (!setting) {
            return { status: 'failed', message: `Print setting with id ${id} not found` };
        }
        return { status: 'success', data: setting };
    }
    async updateSettingFor(settings) {
        return this.printSettingService.updateSettingFor(settings);
    }
};
exports.PrintSettingController = PrintSettingController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], PrintSettingController.prototype, "getPrintSettingById", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [print_setting_entity_1.PrintSetting]),
    __metadata("design:returntype", Promise)
], PrintSettingController.prototype, "updateSettingFor", null);
exports.PrintSettingController = PrintSettingController = __decorate([
    (0, common_1.Controller)('print-settings'),
    __metadata("design:paramtypes", [print_setting_service_1.PrintSettingService])
], PrintSettingController);
//# sourceMappingURL=print_setting.controller.js.map