"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrescriptionIpdController = void 0;
const common_1 = require("@nestjs/common");
const prescription_ipd_service_1 = require("./prescription_ipd.service");
const prescription_ipd_entity_1 = require("./entities/prescription_ipd.entity");
const auth_guard_1 = require("../auth/auth.guard");
let PrescriptionIpdController = class PrescriptionIpdController {
    constructor(prescriptionIpdService) {
        this.prescriptionIpdService = prescriptionIpdService;
    }
    create(createPrescriptionIpd) {
        return this.prescriptionIpdService.create(createPrescriptionIpd);
    }
    findFindingsName(id) {
        return this.prescriptionIpdService.findFindingsName(id);
    }
    findFindingsNameandDesc(id) {
        return this.prescriptionIpdService.findFindingsNameandDesc(id);
    }
    findprescriptionByIpdno(id, search) {
        return this.prescriptionIpdService.findprescriptionByIpdno(id, search);
    }
    findviewPrescription(id) {
        return this.prescriptionIpdService.findviewPrescription(id);
    }
    async removePrescription(id, Hospital_id) {
        await this.prescriptionIpdService.removePrescription(id, Hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    update(id, createPrescriptionIpd) {
        return this.prescriptionIpdService.update(id, createPrescriptionIpd);
    }
    findMedicineName(id) {
        return this.prescriptionIpdService.findMedicineName(id);
    }
    findDosageName(id) {
        return this.prescriptionIpdService.findDosageName(id);
    }
};
exports.PrescriptionIpdController = PrescriptionIpdController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [prescription_ipd_entity_1.PrescriptionIpd]),
    __metadata("design:returntype", void 0)
], PrescriptionIpdController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/findingName/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], PrescriptionIpdController.prototype, "findFindingsName", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/findingNameandDesc/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], PrescriptionIpdController.prototype, "findFindingsNameandDesc", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/prescriptionByIpdno/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String]),
    __metadata("design:returntype", void 0)
], PrescriptionIpdController.prototype, "findprescriptionByIpdno", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/viewPrescriptionBYIPDno/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], PrescriptionIpdController.prototype, "findviewPrescription", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], PrescriptionIpdController.prototype, "removePrescription", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, prescription_ipd_entity_1.PrescriptionIpd]),
    __metadata("design:returntype", void 0)
], PrescriptionIpdController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/findMedicine/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], PrescriptionIpdController.prototype, "findMedicineName", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/findDosage/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], PrescriptionIpdController.prototype, "findDosageName", null);
exports.PrescriptionIpdController = PrescriptionIpdController = __decorate([
    (0, common_1.Controller)('prescription-ipd'),
    __metadata("design:paramtypes", [prescription_ipd_service_1.PrescriptionIpdService])
], PrescriptionIpdController);
//# sourceMappingURL=prescription_ipd.controller.js.map