"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PostalReceiveDispatchService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let PostalReceiveDispatchService = class PostalReceiveDispatchService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(createPostalReceiveDispatch) {
        try {
            const addDispatch = await this.connection.query(`INSERT into dispatch_receive(
       reference_no,
       to_title,
       address,
       note,
       from_title,
       date,
       image,
       type
        ) VALUES (?,?,?,?,?,?,?,?)`, [
                createPostalReceiveDispatch.reference_no,
                createPostalReceiveDispatch.to_title,
                createPostalReceiveDispatch.address,
                createPostalReceiveDispatch.note,
                createPostalReceiveDispatch.from_title,
                createPostalReceiveDispatch.date,
                createPostalReceiveDispatch.image,
                'dispatch'
            ]);
            const addDispatchID = addDispatch.insertId;
            await this.dynamicConnection.query(`INSERT into dispatch_receive(
       reference_no,
       to_title,
       address,
       note,
       from_title,
       date,
       image,
       type,
       hospital_id,
       hos_dispatch_receive_id
          ) VALUES (?,?,?,?,?,?,?,?,?,?)`, [
                createPostalReceiveDispatch.reference_no,
                createPostalReceiveDispatch.to_title,
                createPostalReceiveDispatch.address,
                createPostalReceiveDispatch.note,
                createPostalReceiveDispatch.from_title,
                createPostalReceiveDispatch.date,
                createPostalReceiveDispatch.image,
                'dispatch',
                createPostalReceiveDispatch.hospital_id,
                addDispatchID
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Postal Dispatch details added successfully ",
                        "Dispatch_Details": await this.connection.query('SELECT * FROM dispatch_receive WHERE id = ?', [addDispatchID])
                    }
                }];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
    async updateDispatch(id, createPostalReceiveDispatch) {
        try {
            const fromDate = new Date();
            console.log(fromDate, 'dateeeeee');
            const timestamp = fromDate.toISOString().replace('T', ' ').replace(/\.\d+Z$/, '');
            await this.connection.query(`update dispatch_receive SET
      reference_no=?,
       to_title=?,
       address=?,
       note=?,
       from_title=?,
       date=?,
       image=?
       where id=?`, [
                createPostalReceiveDispatch.reference_no,
                createPostalReceiveDispatch.to_title,
                createPostalReceiveDispatch.address,
                createPostalReceiveDispatch.note,
                createPostalReceiveDispatch.from_title,
                timestamp,
                createPostalReceiveDispatch.image,
                id
            ]);
            const [dyndispatch] = await this.dynamicConnection.query(`select id from dispatch_receive where hospital_id = ? and  hos_dispatch_receive_id = ?`, [createPostalReceiveDispatch.hospital_id, id]);
            const dyndispatchID = dyndispatch.id;
            await this.dynamicConnection.query(`update dispatch_receive SET
       reference_no=?,
       to_title=?,
       address=?,
       note=?,
       from_title=?,
       date=?,
       image=?,
       hospital_id=?
       where id=?`, [
                createPostalReceiveDispatch.reference_no,
                createPostalReceiveDispatch.to_title,
                createPostalReceiveDispatch.address,
                createPostalReceiveDispatch.note,
                createPostalReceiveDispatch.from_title,
                timestamp,
                createPostalReceiveDispatch.image,
                createPostalReceiveDispatch.hospital_id,
                dyndispatchID
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Postal dispatch updated successfully ",
                        "updated_values": await this.connection.query('SELECT * FROM dispatch_receive WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
    async removeFrontofficePostalDispatch(id, hospital_id) {
        try {
            await this.connection.query('DELETE FROM dispatch_receive WHERE id = ?', [id]);
            await this.dynamicConnection.query('DELETE FROM dispatch_receive WHERE hos_dispatch_receive_id = ? and hospital_id = ?', [id, hospital_id]);
            return [
                {
                    status: 'success',
                    message: `postal dispatch details with id: ${id} and associated entries in the dynamic database have been deleted.`,
                },
            ];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
    async createReceive(createPostalReceiveDispatch) {
        try {
            const addReceive = await this.connection.query(`INSERT into dispatch_receive(
         reference_no,
         to_title,
         address,
         note,
         from_title,
         date,
         image,
         type
          ) VALUES (?,?,?,?,?,?,?,?)`, [
                createPostalReceiveDispatch.reference_no,
                createPostalReceiveDispatch.to_title,
                createPostalReceiveDispatch.address,
                createPostalReceiveDispatch.note,
                createPostalReceiveDispatch.from_title,
                createPostalReceiveDispatch.date,
                createPostalReceiveDispatch.image,
                'receive'
            ]);
            const addReceiveID = addReceive.insertId;
            await this.dynamicConnection.query(`INSERT into dispatch_receive(
         reference_no,
         to_title,
         address,
         note,
         from_title,
         date,
         image,
         type,
         hospital_id,
         hos_dispatch_receive_id
            ) VALUES (?,?,?,?,?,?,?,?,?,?)`, [
                createPostalReceiveDispatch.reference_no,
                createPostalReceiveDispatch.to_title,
                createPostalReceiveDispatch.address,
                createPostalReceiveDispatch.note,
                createPostalReceiveDispatch.from_title,
                createPostalReceiveDispatch.date,
                createPostalReceiveDispatch.image,
                'receive',
                createPostalReceiveDispatch.hospital_id,
                addReceiveID
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Postal receive details added successfully ",
                        "Rceive_Details": await this.connection.query('SELECT * FROM dispatch_receive WHERE id = ?', [addReceiveID])
                    }
                }];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
    async updateReceive(id, createPostalReceiveDispatch) {
        try {
            await this.connection.query(`update dispatch_receive SET
        reference_no=?,
         to_title=?,
         address=?,
         note=?,
         from_title=?,
         date=?,
         image=?
         where id=?`, [
                createPostalReceiveDispatch.reference_no,
                createPostalReceiveDispatch.to_title,
                createPostalReceiveDispatch.address,
                createPostalReceiveDispatch.note,
                createPostalReceiveDispatch.from_title,
                createPostalReceiveDispatch.date,
                createPostalReceiveDispatch.image,
                id
            ]);
            const [dyndispatch] = await this.dynamicConnection.query(`select id from dispatch_receive where hospital_id = ? and  hos_dispatch_receive_id = ?`, [createPostalReceiveDispatch.hospital_id, id]);
            const dyndispatchID = dyndispatch.id;
            await this.dynamicConnection.query(`update dispatch_receive SET
         reference_no=?,
         to_title=?,
         address=?,
         note=?,
         from_title=?,
         date=?,
         image=?,
         hospital_id=?
         where id=?`, [
                createPostalReceiveDispatch.reference_no,
                createPostalReceiveDispatch.to_title,
                createPostalReceiveDispatch.address,
                createPostalReceiveDispatch.note,
                createPostalReceiveDispatch.from_title,
                createPostalReceiveDispatch.date,
                createPostalReceiveDispatch.image,
                createPostalReceiveDispatch.hospital_id,
                dyndispatchID
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Postal receive updated successfully ",
                        "updated_values": await this.connection.query('SELECT * FROM dispatch_receive WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            return error;
        }
    }
    async removeFrontofficePostalReceive(id, hospital_id) {
        try {
            await this.connection.query('DELETE FROM dispatch_receive WHERE id = ?', [id]);
            await this.dynamicConnection.query('DELETE FROM dispatch_receive WHERE hos_dispatch_receive_id = ? and hospital_id = ?', [id, hospital_id]);
            return [
                {
                    status: 'success',
                    message: `postal receive details with id: ${id} and associated entries in the dynamic database have been deleted.`,
                },
            ];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
};
exports.PostalReceiveDispatchService = PostalReceiveDispatchService;
exports.PostalReceiveDispatchService = PostalReceiveDispatchService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], PostalReceiveDispatchService);
//# sourceMappingURL=postal_receive_dispatch.service.js.map