"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhrConsultationProcessService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let PhrConsultationProcessService = class PhrConsultationProcessService {
    constructor(dynamicConnection, connection) {
        this.dynamicConnection = dynamicConnection;
        this.connection = connection;
    }
    async findAllColorCode(hospital_id) {
        if (hospital_id) {
            try {
                const query = `SELECT * FROM PT_constultation_process_color_code`;
                const appointmentStatusData = await this.dynamicConnection.query(query);
                return appointmentStatusData;
            }
            catch (error) {
                return error;
            }
        }
        else {
            return {
                status: "failed",
                message: "Enter hospital_id to get the values"
            };
        }
    }
    async findAllProcessList(appointment_id) {
        if (appointment_id) {
            const [getHosId] = await this.connection.query(` select * from appointment where id = ? `, [appointment_id]);
            try {
                if (getHosId.appointment_status_id > 4) {
                    const query = `SELECT * FROM PT_consultation_process_list`;
                    const appointmentStatusData = await this.dynamicConnection.query(query);
                    return appointmentStatusData;
                }
                else {
                    return {
                        "status": "failed",
                        "message": "consultation process will not be shown untill the appointment is in progress."
                    };
                }
            }
            catch (error) {
                return error;
            }
        }
        else {
            return {
                status: "failed",
                message: "Enter appointment_id to get the values"
            };
        }
    }
    async findAllProcessTrackList(appointment_id) {
        if (appointment_id) {
            const [getHosId] = await this.connection.query(` select * from appointment where id = ? `, [appointment_id]);
            try {
                if (getHosId.appointment_status_id > 4) {
                    const query = `select concat(staff.name," ",staff.surname) doctor,
        PT_consultation_process_tracking.description,
        PT_consultation_process_list.process_name Consultation_Process,
        PT_constultation_process_color_code.color_code,
        PT_constultation_process_color_code.name status,
        concat(
        DATE_FORMAT(PT_consultation_process_list.created_at, '%D %b %Y')," ",
        DATE_FORMAT(PT_consultation_process_list.created_at, '%h:%i %p')) timing
        from PT_consultation_process_tracking
        left join staff on staff.id = PT_consultation_process_tracking.staff_id
        left join PT_consultation_process_list
        on PT_consultation_process_list.id = PT_consultation_process_tracking.consultaiton_process_list_id
        left join PT_constultation_process_color_code on PT_constultation_process_color_code.id = PT_consultation_process_tracking.consultation_process_color_code_id
        where PT_consultation_process_tracking.appointment_id = ?`;
                    const appointmentStatusData = await this.dynamicConnection.query(query, [getHosId.hos_appointment_id]);
                    return appointmentStatusData;
                }
                else {
                    return {
                        "status": "failed",
                        "message": "consultation process will not be shown untill the appointment is in progress."
                    };
                }
            }
            catch (error) {
                return error;
            }
        }
        else {
            return {
                status: "failed",
                message: "Enter appointment_id to get the values"
            };
        }
    }
    async ProcessTrackHistory(appointment_id) {
        if (appointment_id) {
            const [getHosId] = await this.connection.query(` select * from appointment where id = ? `, [appointment_id]);
            if (getHosId.appointment_status_id > 4) {
                try {
                    const query = `SELECT * FROM PT_consultation_process_transaction_history`;
                    const appointmentStatusData = await this.dynamicConnection.query(query);
                    return appointmentStatusData;
                }
                catch (error) {
                    return error;
                }
            }
            else {
                return {
                    "status": "failed",
                    "message": "consultation process waiting can be done only when appointment is in progress."
                };
            }
        }
        else {
            return {
                status: "failed",
                message: "Enter hospital_id to get the values"
            };
        }
    }
    async gettrackstats(appointment_id) {
        console.log("1122112");
        if (appointment_id) {
            const [getHosId] = await this.connection.query(`select * from appointment where id = ?`, [appointment_id]);
            try {
                const query = `SELECT 
                        (SELECT COUNT(*) FROM PT_consultation_process_list) AS total,
                        (SELECT COUNT(*) FROM PT_consultation_process_tracking WHERE consultation_process_color_code_id = 3 AND appointment_id = ?) AS completed,
                        (SELECT COUNT(*) FROM PT_consultation_process_tracking WHERE consultation_process_color_code_id = 2 AND appointment_id = ?) AS ongoing,
                        (SELECT COUNT(*) FROM PT_consultation_process_tracking WHERE consultation_process_color_code_id = 1 AND appointment_id = ?) AS waiting,
                        ((SELECT COUNT(*) FROM PT_consultation_process_list) - 
                        ((SELECT COUNT(*) FROM PT_consultation_process_tracking WHERE consultation_process_color_code_id = 3 AND appointment_id = ?) + 
                        (SELECT COUNT(*) FROM PT_consultation_process_tracking WHERE consultation_process_color_code_id = 2 AND appointment_id = ?) +
                        (SELECT COUNT(*) FROM PT_consultation_process_tracking WHERE consultation_process_color_code_id = 1 AND appointment_id = ?))
                        ) AS notAttended`;
                const consultationStatusData = await this.dynamicConnection.query(query, [getHosId.hos_appointment_id, getHosId.hos_appointment_id,
                    getHosId.hos_appointment_id, getHosId.hos_appointment_id, getHosId.hos_appointment_id, getHosId.hos_appointment_id]);
                return consultationStatusData[0];
            }
            catch (error) {
                return error;
            }
        }
        else {
            return {
                status: "failed",
                message: "Enter appointment_id to get the values"
            };
        }
    }
    async checkbooked(updateconsultation) {
        if (!updateconsultation.appointment_id) {
            return [{
                    "status": "failed",
                    "message": "Enter appointment_id to update process"
                }];
        }
        const [getApptDetails] = await this.connection.query(` select * from appointment where id = ? `, [updateconsultation.appointment_id]);
        if (getApptDetails.appointment_status_id >= 3 && getApptDetails.appointment_status_id != 4) {
            const [getApptDetails] = await this.connection.query(` select * from appointment where id = ? `, [updateconsultation.appointment_id]);
            try {
                if (updateconsultation.appointment_id && updateconsultation.consultaiton_process_list_id) {
                    const recordExistsQuery = `
                SELECT id
                FROM PT_consultation_process_tracking
                WHERE appointment_id = ? AND consultaiton_process_list_id = ? 
            `;
                    const [existingRecord] = await this.dynamicConnection.query(recordExistsQuery, [getApptDetails.hos_appointment_id, updateconsultation.consultaiton_process_list_id]);
                    if (existingRecord) {
                        return [{
                                "status": "failed",
                                "message": "already initiated"
                            }];
                    }
                    else {
                        return [{
                                "status": "success",
                                "message": "can be initiated"
                            }];
                    }
                }
            }
            catch (error) {
                console.error('Error in process update:', error);
                return [{
                        "status": "failed",
                        "message": "Error in process update"
                    }];
            }
        }
        else {
            return {
                "status": "failed",
                "message": "consultation process waiting can be done only when appointment is in progress."
            };
        }
    }
    async createWaiting(updateconsultation) {
        if (!updateconsultation.appointment_id) {
            return [{
                    "status": "failed",
                    "message": "Enter appointment_id to update process"
                }];
        }
        const [getApptDetails] = await this.connection.query(` select * from appointment where id = ? `, [updateconsultation.appointment_id]);
        if (getApptDetails.appointment_status_id > 4) {
            const [getApptDetails] = await this.connection.query(` select * from appointment where id = ? `, [updateconsultation.appointment_id]);
            try {
                if (updateconsultation.appointment_id && updateconsultation.consultaiton_process_list_id) {
                    const recordExistsQuery = `
                SELECT id
                FROM PT_consultation_process_tracking
                WHERE appointment_id = ? AND consultaiton_process_list_id = ?
            `;
                    const [existingRecord] = await this.dynamicConnection.query(recordExistsQuery, [getApptDetails.hos_appointment_id, updateconsultation.consultaiton_process_list_id]);
                    if (existingRecord) {
                        return [{
                                "status": "success",
                                "message": "Consultation Process has already been initiated."
                            }];
                    }
                    else {
                        const [getAdminPatientDetails] = await this.connection.query(`select * from patients where id = ?`, [updateconsultation.patient_id]);
                        const [getHosPatientId] = await this.dynamicConnection.query(`select * from patients where aayush_unique_id = ?`, [
                            getAdminPatientDetails.aayush_unique_id
                        ]);
                        const [getHosProcessListId] = await this.connection.query(`select * from PT_consultation_process_list
   where hos_PT_consultation_process_list_id = ? and 
   hospital_id = ? `, [updateconsultation.consultaiton_process_list_id, getApptDetails.Hospital_id]);
                        const updateResult = await this.dynamicConnection.query(`
                    INSERT INTO PT_consultation_process_tracking
                        (patient_id, appointment_id, consultation_process_color_code_id, 
                          consultaiton_process_list_id, description)
                    VALUES (?, ?, ?, ?, ?)`, [
                            getHosPatientId.id,
                            getApptDetails.hos_appointment_id,
                            1,
                            updateconsultation.consultaiton_process_list_id,
                            updateconsultation.description
                        ]);
                        await this.connection.query(`
                                  INSERT INTO PT_consultation_process_tracking
                                      (patient_id, appointment_id, consultation_process_color_code_id, consultaiton_process_list_id,
                                         description,hospital_id,hos_consultation_process_tracking_id)
                                  VALUES (?, ?, ?, ?, ?,?,?)`, [
                            updateconsultation.patient_id,
                            updateconsultation.appointment_id,
                            1,
                            getHosProcessListId.id,
                            updateconsultation.description,
                            getApptDetails.Hospital_id,
                            updateResult.insertId
                        ]);
                        return [{
                                "status": "success",
                                "message": "consultation Process inserted successfully"
                            }];
                    }
                }
            }
            catch (error) {
                console.error('Error in process update:', error);
                return [{
                        "status": "failed",
                        "message": "Error in process update"
                    }];
            }
        }
        else {
            return {
                "status": "failed",
                "message": "consultation process waiting can be done only when appointment is in progress."
            };
        }
    }
};
exports.PhrConsultationProcessService = PhrConsultationProcessService;
exports.PhrConsultationProcessService = PhrConsultationProcessService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], PhrConsultationProcessService);
//# sourceMappingURL=phr-consultation-process.service.js.map