"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhrConsultationProcessController = void 0;
const common_1 = require("@nestjs/common");
const phr_consultation_process_service_1 = require("./phr-consultation-process.service");
const phr_consultation_process_entity_1 = require("./entities/phr-consultation-process.entity");
let PhrConsultationProcessController = class PhrConsultationProcessController {
    constructor(phrConsultationProcessService) {
        this.phrConsultationProcessService = phrConsultationProcessService;
    }
    async findAll(hospital_id) {
        return this.phrConsultationProcessService.findAllColorCode(hospital_id);
    }
    async findAllprocess(appointment_id) {
        return this.phrConsultationProcessService.findAllProcessList(appointment_id);
    }
    async findAllprocesstrack(appointment_id) {
        return this.phrConsultationProcessService.findAllProcessTrackList(appointment_id);
    }
    async findAllprocesstrackhistory(appointment_id) {
        return this.phrConsultationProcessService.ProcessTrackHistory(appointment_id);
    }
    async getConsultationProcessStats(appointment_id) {
        return this.phrConsultationProcessService.gettrackstats(appointment_id);
    }
    async waitingPost(updateConsultation) {
        return this.phrConsultationProcessService.createWaiting(updateConsultation);
    }
    async check(updateConsultation) {
        return this.phrConsultationProcessService.checkbooked(updateConsultation);
    }
};
exports.PhrConsultationProcessController = PhrConsultationProcessController;
__decorate([
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], PhrConsultationProcessController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)('process'),
    __param(0, (0, common_1.Query)('appointment_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], PhrConsultationProcessController.prototype, "findAllprocess", null);
__decorate([
    (0, common_1.Get)('tracking'),
    __param(0, (0, common_1.Query)('appointment_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], PhrConsultationProcessController.prototype, "findAllprocesstrack", null);
__decorate([
    (0, common_1.Get)('process_history'),
    __param(0, (0, common_1.Query)('appointment_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], PhrConsultationProcessController.prototype, "findAllprocesstrackhistory", null);
__decorate([
    (0, common_1.Get)('stats'),
    __param(0, (0, common_1.Query)('appointment_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], PhrConsultationProcessController.prototype, "getConsultationProcessStats", null);
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [phr_consultation_process_entity_1.PhrConsultationProcess]),
    __metadata("design:returntype", Promise)
], PhrConsultationProcessController.prototype, "waitingPost", null);
__decorate([
    (0, common_1.Post)('/check'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [phr_consultation_process_entity_1.PhrConsultationProcess]),
    __metadata("design:returntype", Promise)
], PhrConsultationProcessController.prototype, "check", null);
exports.PhrConsultationProcessController = PhrConsultationProcessController = __decorate([
    (0, common_1.Controller)('phr-consultation-process'),
    __metadata("design:paramtypes", [phr_consultation_process_service_1.PhrConsultationProcessService])
], PhrConsultationProcessController);
//# sourceMappingURL=phr-consultation-process.controller.js.map