import { DataSource } from 'typeorm';
import { PhrAppointment } from './entities/phr-appointment.entity';
import { EventEmitter2 } from '@nestjs/event-emitter';
import { FaceAuthService } from 'src/face-auth/face-auth.service';
import { TransactionSplitService } from 'src/transaction_split/transaction_split.service';
export declare class PhrAppointmentService {
    private readonly dynamicConnection;
    private readonly connection;
    private readonly eventEmitter;
    private readonly addAppointmentService;
    private readonly TransactionShareService;
    constructor(dynamicConnection: DataSource, connection: DataSource, eventEmitter: EventEmitter2, addAppointmentService: FaceAuthService, TransactionShareService: TransactionSplitService);
    handleOrderCreatedEvent(smsData: any, emailData: any): void;
    RefundApptCharge(payment_id: any, PatientChargesDetailsId: any, AdminPatientChargesDetailsId: any): void;
    RefundTempApptCharge(payment_id: any): void;
    TransferToSubmerchant(payment_id: any, getPaymentGatewayDetails: any, hospital_id: any, patient_aayush_id: any, admin_transaction_id: any, hos_transaction_id: any): Promise<void>;
    sendnotificationApptDeleteEvent(verifyData: any, emailData: any): void;
    sendnotificationTempApptCreateEvent(verifyData: any, emailData: any): void;
    sendnotificationApptUpdateEvent(verifyData: any, emailData: any): void;
    convertTo12HourFormat(time: any): Promise<any>;
    create(AppointmentEntity: PhrAppointment): Promise<any>;
    findAll(): string;
    findOne(appointment_id: number): Promise<any>;
    findOneQR(token: string): Promise<any[] | {
        QR_Type_id: number;
        QR_Type: string;
        Appointment_details: any;
    }>;
    update(id: number, AppointmentEntity: PhrAppointment): Promise<any>;
    remove(id: number): Promise<any>;
    updateCancelApp(id: number, AppointmentEntity: PhrAppointment): Promise<string | {
        status: string;
        messege: string;
        inserted_details: any;
    }[]>;
}
